 # delimit ;
set more off;
capture log close;
program drop _all;
clear all; 
*set more 1;
set mem 300m; 
set seed 125;
local UNIX 0;
local divide 1; * decide whether to divide oop and tc by 1 or two;

*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";

global folder "D:\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";




         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";	
 		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";		 
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";


log using `saved'exitmed.log, replace;

* Note for adding Wave 13 (and 14) data - the values for don't know / missing answers changes very frequently ///
* for this file so make sure to check the latest copy of the codebook and update the code accordingly


*******************************************************;
* All variable names start with "d", for "dead"        ;
* diprem = insurance premia                            ;
* ddrugc = drug costs                                  ;
* doop = out of pocket costs (other than drug costs)   ;
* dmedc=doop+ddrugc+diprem (total med costs paid by hh);
* dtc= total cost (paid by hh and insurance company for medical services);
*******************************************************;

*******************************************************;
* nobody is dead in wave 1                             ;
* for wave 2 of the hrs, exit information is included with the core files;
* therefore, we just need to code hrs wave 3,4,5,6 and ahead wave 2;
*******************************************************;
*******************WAVE2AHEAD************************;
use `aheadw2'x95i_er;
*Names important Variables and discards the rest;

*Out of pocket costs = Hospital costs + Doctor costs + Hospice + In home Med Care/Special + Other oop + non-med;
gen doop2 = N1688X + N1732X + N1703X + N1781X + N1792X + N1805X;
replace doop2=doop2/`divide';
rename N1749X ddrugc2;
replace ddrugc2 = ddrugc2 * 12;

keep HHID PN doop2 ddrugc2;

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN;
sleep 1000;
save `aheadw2'imp.dta, replace ; 

clear;

*x95R_R contains the same information as a2_exit;
*use `aheadw2'a2_exit;
use `aheadw2'X95R_R;

gen dmedicaid1=.;
gen dmedicaid2=9;
replace dmedicaid2= 1 if N5286==1;
replace dmedicaid2=0 if N5286==5;

* Medicare HMO Premiums;
replace N5324 = 0 if N5324 == .;
replace N5324 = 0 if N5324 == 99997;
replace N5324 = 0 if N5324 == 99998;
replace N5324 = 0 if N5324 == 99999;

replace N5324 = N5324*12 if N5325 == 1;
replace N5324 = N5324*4 if N5325 == 2;
replace N5324 = N5324*0 if N5325 == 4;

* Other Health Insurance;
replace N5352 = 0 if N5352 == .;
replace N5352 = 0 if N5352 == 99998;
replace N5352 = 0 if N5352 == 99999;

replace N5352 = N5352*12 if N5353 == 1;
replace N5352 = N5352*4 if N5353 == 2;
replace N5352 = N5352*0 if N5353 == 4;

* Other Health Insurance 2;
replace N5364 = 0 if N5364 == .;
replace N5364 = 0 if N5364 == 99997;
replace N5364 = 0 if N5364 == 99998;
replace N5364 = 0 if N5364 == 99999;

replace N5364 = N5364*12 if N5365 == 1;
replace N5364 = N5364*4 if N5365 == 2;
replace N5364 = N5364*0 if N5365 == 4;

* That's diprem = Medicare HMO + other HMO premiums + other insurance premiums;
gen diprem2 = N5324 + N5352 + N5364;

sum diprem2;

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN;

merge HHID PN using `aheadw2'imp.dta;
drop _merge;
sort HHID PN;
sleep 1000;
save `aheadw2'imp.dta, replace;

clear;

*x95E_R contains the same information as a2_exit;
use `aheadw2'x95E_R;

* Total Medical Costs;
gen dtc2 = 0;
replace dtc2 = 500000 if N1803 == 1;
replace dtc2 = 300000 if N1802 == 1 & dtc2 == 0;
replace dtc2 = 62500 if N1801 == 1 & dtc2 == 0;
replace dtc2 = 15000 if N1799 == 1 & dtc2 == 0;
replace dtc2 = 3000 if N1800 == 1 & dtc2 == 0;
replace dtc2 = 500 if N1800 == 5 & dtc2 == 0;

replace dtc2=dtc2/`divide';


keep HHID PN dtc2;

sort HHID PN; 

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN;

merge HHID PN using `aheadw2'imp.dta;


drop if _merge ~= 3;
drop _merge;

gen dmedc2=doop2+ddrugc2+diprem2;

sort HHID PN; 
sleep 1000;
save `saved'exitw2, replace;

*************************WAVE 3**********************************************;

use `wave3d'x96R_R.dta;

gen dmedicaid3=9;
replace dmedicaid3=1 if P2177==1;
replace dmedicaid3=0 if P2177==5;

*Replaces missing values, unknowns and refused answers with zero;

replace P2216 = 0 if P2216 == 99998;
replace P2216 = 0 if P2216 == 99999;
replace P2216 = 0 if P2216 == .;

replace P2216 = P2216 * 12 if P2217 == 1;
replace P2216 = P2216 * 4 if P2217 == 2;
replace P2216 = P2216 * 0 if P2217 == 4;

replace P2244 = 0 if P2244 == 99998;
replace P2244 = 0 if P2244 == 99999;
replace P2244 = 0 if P2244 == .;

replace P2244 = P2244 * 12 if P2245 == 1;
replace P2244 = P2244 * 4 if P2245 == 2;
replace P2244 = P2244 * 0 if P2245 == 4;

replace P2256 = 0 if P2256 == 99998;
replace P2256 = 0 if P2256 == 99999;
replace P2256 = 0 if P2256 == .;

replace P2256 = P2256 * 12 if P2257 == 1;
replace P2256 = P2256 * 4 if P2257 == 2;
replace P2256 = P2256 * 0 if P2257 == 4;



* That's diprem = medicare premiums + HMO premiums + other insurance premiums;
gen diprem3 = P2216 + P2244 + P2256;

keep HHID PN diprem dmedicaid3 ;

sort HHID PN;
sleep 1000;
save `wave3d'nonimp.dta, replace;

clear;

use `wave3d'x96E_R;

gen dtc3 = 0;
replace dtc3 = 500000 if P1384 == 1;
replace dtc3 = 300000 if P1383 == 1 & dtc3 == 0;
replace dtc3 = 62500 if P1382 == 1 & dtc3 == 0;
replace dtc3 = 15000 if P1380 == 1 & dtc3 == 0;
replace dtc3 = 3000 if P1381 == 1 & dtc3 == 0;
replace dtc3 = 500 if P1381 == 5 & dtc3 == 0;

replace dtc3=dtc3/`divide';

keep HHID PN dtc;

sort HHID PN;

save `wave3d'nidtc.dta, replace;

clear;

use `wave3d'x96i_er;

*Names important Variables and discards the rest;

*Out of pocket costs = Hospital costs + Doctor costs + In home Med Care + Other oop + non-med;
gen doop3 = P1269X + P1313X + P1362X + P1373X + P1386X;
sum doop3;
replace doop3=doop3/`divide';
sum doop3;


rename P1330X ddrugc3;
replace ddrugc3 = ddrugc3 * 12;

keep HHID PN doop3 ddrugc3;

save `wave3d'imp.dta, replace; 

sort HHID PN;

merge HHID PN using `wave3d'nonimp.dta;
drop _merge;
sort HHID PN;
merge HHID PN using `wave3d'nidtc.dta;
drop _merge;
gen dmedc3 = doop3 + ddrugc3 + diprem3;

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

sort HHID PN;
merge HHID PN using `saved'exitw2;
drop _merge;
sort HHID PN;
save `wave3d'wave3exit, replace;


clear;

*************** WAVE IV *****************; 
clear; 
set mem 100m; 
*x98i_er has these variables in new data;
*use `wave4d'h1998xi;
use `wave4d'x98i_er;
gen doop4=Q1749X+Q1770X+Q1784X +Q1811X+Q1818X+Q1844X; // two year variable; 
replace doop4=doop4/`divide';
* Note: the above formula for doop4 may not be correct, ;
*it depends on what costs you would like to incorporate into the out-of-pocket costs.;
* For example, maybe you don't like to incorporate the health-related non-medical costs into doop4;
* Q1749X=out-of-pocket hospital/nursing home stay cost; 
* Q1770X=out-of-pocket hospice cost; 
* Q1784X=out-of-pocket doctor visit cost; 
* Q1794X=out-of-pockte prescription cost, which is monthly variable; 
* Q1811X=out-of-pocket in-home services/special facilities or services out-pocket cost; 
* Q1818X=other out-of-pocket costs; 
* Q1844X=out-of-pocket health-related non-medical costs (e.g., wheelchairs);
gen ddrugc4=Q1794X*12; // yearly out-of-pocket drug costs;


keep HHID PN doop4 ddrugc4; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave4d'X98R_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid4=9;
replace dmedicaid4=1 if Q2562==1;
replace dmedicaid4=0 if Q2562==5;

gen epins=.;// employer provided insurance;
replace Q2592=. if Q2592>9996;
sort Q2593;
by Q2593: sum Q2592;
replace epins=Q2592 if Q2593==1;
replace epins=Q2592*4 if Q2593==2;
replace epins=Q2592*12 if Q2593==4;
replace epins=Q2592*52 if Q2593==5;
replace epins=Q2592*26 if Q2593==6;

gen medigap=.; //"Medigap" insurance;
replace Q2612=. if Q2612> 999996;
sort Q2613;
by Q2613: sum Q2612;
replace medigap=Q2612*12 if Q2613==1;
replace medigap=Q2612*4 if Q2613==2;
replace medigap=Q2612*2 if Q2613==3;
replace medigap=Q2612 if Q2613==4;

gen AARP=.; // insurance purchased through AARP, or some other organization;
* not totally sure how this is different from medigap;
replace Q2624=. if Q2624> 999996;
sort Q2625;
by Q2625: sum Q2624;
replace AARP=Q2624*12 if Q2625==1;
replace AARP=Q2624*4 if Q2625==2;
replace AARP=Q2624*2 if Q2625==3;
replace AARP=Q2624 if Q2625==4;

gen LTC=.; // long term care insurance;
replace Q2668=. if Q2668>999997;
sort Q2669;
by Q2669: sum Q2668;
replace LTC=Q2668 if Q2669==1;
replace LTC=Q2668*12 if Q2669==4;

sum epins medigap AARP LTC;

* I hate doing this, because almost half of the people who were spending money on health insurance don't have reliable average numbers - here I set their insurance expenses to zero;
replace epins=0 if epins==.;
replace medigap=0 if medigap==.;
replace AARP=0 if AARP==.;
replace LTC=0 if LTC==.;

gen diprem4=epins+medigap+AARP+LTC;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge;

sort HHID PN; 
merge HHID PN using `wave3d'wave3exit;
drop _merge;


gen dmedc4=doop4+ddrugc4+diprem4; // still to do -add in insurance premia ;


sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 

clear;
set mem 100m; 
use `wave4d'x98e_R; //Jon: There were two files that could be used for this. ;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 

clear; 
set mem 100m; 
use `wave4d'X98PR_R; //Jon: Again, there were two updated files that could be used here. ;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
keep HHID PN Q122; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 

clear; 
set mem 100m; 
use `wave4d'X98CS_R; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
keep HHID PN Q694 Q519 Q491; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge;




* re-code total medical costs;
gen dtc4=.;
*replace dtc4=0 if Q694==.; * the case where Q456==5, only one such observation;
replace dtc4=dmedc4 if 
Q1735==5 
& 
(Q1748==5|Q1743==5|Q1743==8) 
& 
(Q1779==5|Q1778==0) 
& 
(Q1793==5|Q1792==5|Q1792==8)
& 
(Q519==1|Q1806==5|Q1804==5|Q1804==8) 
& 
(Q519==1|Q1808==5|Q1808==8); 
replace dtc4=dmedc4 if 
(Q1728==5|Q1728==8) & Q491~=1 
& 
(Q1748==5|Q1743==5|Q1743==8) 
& 
(Q1779==5|Q1778==0) 
& 
(Q1793==5|Q1792==5|Q1792==8)
& 
(Q519==1|Q1806==5|Q1804==5|Q1804==8) 
& 
(Q519==1|Q1808==5|Q1808==8); 
replace dtc4=. if 
(Q1735==8|Q1735==9) 
& (Q1748~=1 & Q1748~=3 & Q1748~=7) 
& (Q1779~=1 & Q1779~=3 & Q1779~=7) 
& (Q1793~=1 & Q1793~=3 & Q1793~=7) 
& (Q1806~=1 & Q1806~=3 & Q1806~=7) 
& Q1808~=1;
replace dtc4=. if 
(Q1728==9 & Q491~=1) 
& (Q1748~=1 & Q1748~=3 & Q1748~=7) 
& (Q1779~=1 & Q1779~=3 & Q1779~=7) 
& (Q1793~=1 & Q1793~=3 & Q1793~=7) 
& (Q1806~=1 & Q1806~=3 & Q1806~=7) 
& Q1808~=1;
replace dtc4=. if 
(Q1735~=1 & Q1735~=3 & Q1735~=7) 
& (Q1748==8|Q1748==9|Q1743==9) 
& (Q1779~=1 & Q1779~=3 & Q1779~=7) 
& (Q1793~=1 & Q1793~=3 & Q1793~=7) 
& (Q1806~=1 & Q1806~=3 & Q1806~=7) 
& Q1808~=1;
replace dtc4=. if 
(Q1735~=1 & Q1735~=3 & Q1735~=7) 
& (Q1748~=1 & Q1748~=3 & Q1748~=7) 
& (Q1779==8|Q1779==9|Q1778==998|Q1778==999) 
& (Q1793~=1 & Q1793~=3 & Q1793~=7) 
& (Q1806~=1 & Q1806~=3 & Q1806~=7) 
& Q1808~=1;
replace dtc4=. if 
(Q1735~=1 & Q1735~=3 & Q1735~=7) 
& (Q1748~=1 & Q1748~=3 & Q1748~=7) 
& (Q1779~=1 & Q1779~=3 & Q1779~=7) 
& (Q1793==8|Q1793==9|Q1792==8|Q1792==9) 
& (Q1806~=1 & Q1806~=3 & Q1806~=7) 
& Q1808~=1;
replace dtc4=. if 
(Q1735~=1 & Q1735~=3 & Q1735~=7) 
& (Q1748~=1 & Q1748~=3 & Q1748~=7) 
& (Q1779~=1 & Q1779~=3 & Q1779~=7) 
& (Q1793~=1 & Q1793~=3 & Q1793~=7) 
& (Q1806==8|Q1806==9|Q1804==9) 
& Q1808~=1;
replace dtc4=. if 
(Q1735~=1 & Q1735~=3 & Q1735~=7) 
& (Q1748~=1 & Q1748~=3 & Q1748~=7) 
& (Q1779~=1 & Q1779~=3 & Q1779~=7) 
& (Q1793~=1 & Q1793~=3 & Q1793~=7) 
& (Q1806~=1 & Q1806~=3 & Q1806~=7) 
& Q1808==9;

* DK, NA, RF;
replace dtc4=0 if (Q1837>5 & doop4~=.);

* when Q122==1;
replace dtc4=500 if Q122==1 & Q1837==1; 
replace dtc4=1000 if Q122==1 & Q1837==3; 
replace dtc4=. if Q122==1 & (Q1837==8|Q1837==9);
replace dtc4=3000 if Q122==1 & Q1838==1; 
replace dtc4=5000 if Q122==1 & Q1838==3; 
replace dtc4=2000 if Q122==1 & (Q1838==8|Q1838==9);
replace dtc4=15000 if Q122==1 & Q1839==1; 
replace dtc4=25000 if Q122==1 & Q1839==3; 
replace dtc4=10000 if Q122==1 & (Q1839==8|Q1839==9);

* when Q122==2;
replace dtc4=5000 if Q122==2 & Q1837==3; 
replace dtc4=. if Q122==2 & (Q1837==8|Q1837==9);
replace dtc4=500 if Q122==2 & Q1837==1 & Q1839==1; 
replace dtc4=1000 if Q122==2 & Q1837==1 & Q1839==3; 
replace dtc4=3000 if Q122==2 & Q1837==1 & Q1839==5; 
replace dtc4=2500 if Q122==2 & Q1837==1 & (Q1839==8|Q1839==9);
replace dtc4=15000 if Q122==2 & Q1837==5 & Q1839==1; 
replace dtc4=25000 if Q122==2 & Q1837==5 & Q1839==3; 
replace dtc4=10000 if Q122==2 & Q1837==5 & (Q1839==8|Q1839==9);
* when Q122==3;
replace dtc4=25000 if Q122==3 & Q1837==3; 
replace dtc4=. if Q122==3 & (Q1837==8|Q1837==9);
replace dtc4=5000 if Q122==3 & Q1838==3; 
replace dtc4=15000 if Q122==3 & Q1838==5; 
replace dtc4=12500 if Q122==3 & (Q1838==8|Q1838==9);
replace dtc4=500 if Q122==3 & Q1839==1; 
replace dtc4=1000 if Q122==3 & Q1839==3; 
replace dtc4=3000 if Q122==3 & Q1839==5; 
replace dtc4=2500 if Q122==3 & (Q1839==8|Q1839==9);
* for Q122==1|Q122==2|Q122==3; 
replace dtc4=62500 if Q1840==1; 
replace dtc4=100000 if Q1840==3; 
replace dtc4=50000 if Q1840==8|Q1840==9;
replace dtc4=300000 if Q1841==1; 
replace dtc4=500000 if Q1841==3; 
replace dtc4=1000000 if Q1841==5; 
replace dtc4=200000 if Q1841==8|Q1841==9;

* there are about 150 missing obs -- not sure why;
replace dtc4=0 if doop4~=. & dtc4==.;


replace dtc4=dtc4/`divide'; // convert into annual variable;

keep HHID PN doop* ddrugc* diprem* dmed* dtc*; 
sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 


********************* exit hrs 2000 *********************;
*************************WAVE V**************************;
clear; 
use `wave5d'h2000xi;
gen doop5=R1760X+R1781X+R1800X +R1827X+R1835X+R1864X; // two year variable; 
replace doop5=doop5/`divide'; // convert into one-year variable;
* Note: the above formula for doop5 may not be correct, it depends on what costs you would like to incorporate into the out-of-pocket costs. For example, maybe you don't like to incorporate the health-related non-medical costs into doop5;
* R1760X=out-of-pocket hospital/nursing home stay cost; 
* R1781X=out-of-pocket hospice cost; 
* R1800X=out-of-pocket doctor visit cost; 
* R1810X=out-of-pockte prescription cost, which is monthly variable; 
* R1827X=out-of-pocket in-home services/special facilities or services out-pocket cost; 
* R1835X=other out-of-pocket costs; 
* R1864X=out-of-pocket health-related non-medical costs;
gen ddrugc5=R1810X*12; // yearly out-of-pocket drug costs;

gen dmedc5=doop5+ddrugc5;

keep HHID PN doop5 ddrugc5 dmedc5; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave5d'X00R_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid5=9;
replace dmedicaid5=1 if R2588==1;
replace dmedicaid5=0 if R2588==5;

gen epins=.;// employer provided insurance;
replace R2620=. if R2620>9996;
sort R2621;
by R2621: sum R2620;
replace epins=R2620 if R2621==1;
replace epins=R2620*4 if R2621==2;
replace epins=R2620*6 if R2621==3;
replace epins=R2620*12 if R2621==4;
replace epins=R2620*52 if R2621==5;
replace epins=R2620*26 if R2621==6;
replace epins=R2620*2 if R2621==7;

gen medigap=.; //"Medigap" insurance;
replace R2636=. if R2636> 999996;
sort R2637;
by R2637: sum R2636;
replace medigap=R2636 if R2637==1;
replace medigap=R2636*4 if R2637==2;
replace medigap=R2636*6 if R2637==3;
replace medigap=R2636*12 if R2637==4;
replace medigap=R2636*52 if R2637==5;
replace medigap=R2636*26 if R2637==6;
replace medigap=R2636*2 if R2637==7;
replace medigap=R2636*24 if R2637==8;

gen AARP=.; // insurance purchased through AARP, or some other organization;
* not totally sure how this is different from medigap;
replace R2648=. if R2648> 999996;
sort R2649;
by R2649: sum R2648;
replace AARP=R2648 if R2649==1;
replace AARP=R2648*4 if R2649==2;
replace AARP=R2648*24 if R2649==3;
replace AARP=R2648*12 if R2649==4;

gen LTC=.; *// long term care insurance;
replace R2704=. if R2704>999997;
sort R2705;
by R2705: sum R2704;
replace LTC=R2704 if R2705==1;
replace LTC=R2704*4 if R2705==2;
replace LTC=R2704*12 if R2705==4;

sum epins medigap AARP LTC;

* I hate doing this, because almost half of the people who were spending money on health insurance don't have reliable average numbers - here I set their insurance expenses to zero;
replace epins=0 if epins==.;
replace medigap=0 if medigap==.;
replace AARP=0 if AARP==.;
replace LTC=0 if LTC==.;

gen diprem5=epins+medigap+AARP+LTC;

sort HHID PN; 
merge HHID PN using `saved'exit; 

replace dmedc5=doop5+ddrugc5+diprem5; // still to do -add in insurance premia ;
drop _merge;
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
**************************************************;

use `wave5d'X00E_R; //Jon: There were two updated datasets that could be used here. ;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000;
sleep 1000; save `saved'exit, replace; 
clear;

 
use `wave5d'X00PR_R; //Jon: Two datasets here. ;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
keep HHID PN R122; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave5d'x00CS_R; //Jon: Two updated datasets could have been used here. ;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
keep HHID PN R558 R525; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge;


* re-coding the total cost;
gen dtc5=.;
replace dtc5=dmedc5 if
R1746==5 
& 
(R1759==5|R1754==5|R1754==8) 
& 
(R1795==5|R1789==0) 
& 
(R1809==5|R1808==5|R1808==8) 
& 
(R1822==5|R558==1|R1820==5|R1820==8) 
& 
(R1824==5|R1824==8);
replace dtc5=dmedc5 if 
R1746==5 
& 
(R525==2|R558==1) & R1755==1 
& 
(R1795==5|R1789==0) 
& 
(R1809==5|R1808==5|R1808==8) 
& 
(R1822==5|R558==1|R1820==5|R1820==8) 
& 
(R1824==5|R1824==8);
replace dtc5=dmedc5 if 
(R1739==5|R1739==8) & R525~=1 
& 
(R1759==5|R1754==5|R1754==8) 
& 
(R1795==5|R1789==0) 
& 
(R1809==5|R1808==5|R1808==8) 
& 
(R1822==5|R558==1|R1820==5|R1820==8) 
& 
(R1824==5|R1824==8);
replace dtc5=dmedc5 if 
(R1739==5|R1739==8) & R525~=1 
& 
(R525==2|R558==1) & R1755==1 
& 
(R1795==5|R1789==0) 
& 
(R1809==5|R1808==5|R1808==8) 
& 
(R1822==5|R558==1|R1820==5|R1820==8) 
& 
(R1824==5|R1824==8);



replace dtc5=. if 
(R1746==8|R1746==9) 
& (R1759~=1 & R1759~=3 & R1759~=7) 
& (R1795~=1 & R1795~=3 & R1795~=7) 
& (R1809~=1 & R1809~=3 & R1809~=7) 
& (R1822~=1 & R1822~=3 & R1822~=7) 
& R1824~=1;
replace dtc5=. if 
R1739==9 & R525~=1 
& (R1759~=1 & R1759~=3 & R1759~=7) 
& (R1795~=1 & R1795~=3 & R1795~=7) 
& (R1809~=1 & R1809~=3 & R1809~=7) 
& (R1822~=1 & R1822~=3 & R1822~=7) 
& R1824~=1;

replace dtc5=. if 
(R1746~=1 & R1746~=3 & R1746~=7) 
& (R1759==8|R1759==9|R1754==9) 
& (R1795~=1 & R1795~=3 & R1795~=7) 
& (R1809~=1 & R1809~=3 & R1809~=7) 
& (R1822~=1 & R1822~=3 & R1822~=7) 
& R1824~=1;


replace dtc5=. if 
(R1746~=1 & R1746~=3 & R1746~=7) 
& (R1759~=1 & R1759~=3 & R1759~=7) 
& (R1795==8|R1795==9|R1789==998|R1789==999) 
& (R1809~=1 & R1809~=3 & R1809~=7) 
& (R1822~=1 & R1822~=3 & R1822~=7) 
& R1824~=1; 
replace dtc5=. if 
(R1746~=1 & R1746~=3 & R1746~=7) 
& (R1759~=1 & R1759~=3 & R1759~=7) 
& (R1795~=1 & R1795~=3 & R1795~=7) 
& (R1809==8|R1809==9|R1808==9) 
& (R1822~=1 & R1822~=3 & R1822~=7) 
& R1824~=1;

replace dtc5=. if 
(R1746~=1 & R1746~=3 & R1746~=7) 
& (R1759~=1 & R1759~=3 & R1759~=7) 
& (R1795~=1 & R1795~=3 & R1795~=7) 
& (R1809~=1 & R1809~=3 & R1809~=7) 
& (R1822==8|R1822==9|R1820==9) 
& R1824~=1;

replace dtc5=. if 
(R1746~=1 & R1746~=3 & R1746~=7) 
& (R1759~=1 & R1759~=3 & R1759~=7) 
& (R1795~=1 & R1795~=3 & R1795~=7) 
& (R1809~=1 & R1809~=3 & R1809~=7) 
& (R1822~=1 & R1822~=3 & R1822~=7) 
& (R1824==9|R1824==.);

* breaking the brackets; 
* when R122==1;
replace dtc5=500 if R122==1 & R1854==1; 
replace dtc5=1000 if R122==1 & R1854==3; 
replace dtc5=. if R122==1 & (R1854==8|R1854==9);
replace dtc5=3000 if R122==1 & R1855==1; 
replace dtc5=5000 if R122==1 & R1855==3; 
replace dtc5=2000 if R122==1 & (R1855==8|R1855==9);
replace dtc5=15000 if R122==1 & R1859==1; 
replace dtc5=25000 if R122==1 & R1859==3; 
replace dtc5=10000 if R122==1 & (R1859==8|R1859==9);

* when R122==2;
replace dtc5=5000 if R122==2 & R1854==3; 
replace dtc5=. if R122==2 & (R1854==8|R1854==9);
replace dtc5=500 if R122==2 & R1854==1 & R1859==1;
replace dtc5=1000 if R122==2 & R1854==1 & R1859==3; 
replace dtc5=3000 if R122==2 & R1854==1 & R1859==5; 
replace dtc5=2500 if R122==2 & R1854==1 & (R1859==8|R1859==9);
replace dtc5=15000 if R122==2 & R1854==5 & R1859==1; 
replace dtc5=25000 if R122==2 & R1854==5 & R1859==3; 
replace dtc5=10000 if R122==2 & R1854==5 & (R1859==8|R1859==9);
* when R122==3;
replace dtc5=25000 if R122==3 & R1854==3; 
replace dtc5=. if R122==3 & (R1854==8|R1854==9);
replace dtc5=5000 if R122==3 & R1855==3; 
replace dtc5=15000 if R122==3 & R1855==5; 
replace dtc5=12500 if R122==3 & (R1855==8|R1855==9);
replace dtc5=500 if R122==3 & R1859==1; 
replace dtc5=1000 if R122==3 & R1859==3; 
replace dtc5=3000 if R122==3 & R1859==5; 
replace dtc5=2500 if R122==3 & (R1859==8|R1859==9);
* for R122==1|R122==2|R122==3; 
replace dtc5=62500 if R1860==1; 
replace dtc5=100000 if R1860==3; 
replace dtc5=50000 if R1860==8|R1860==9;
replace dtc5=300000 if R1861==1; 
replace dtc5=500000 if R1861==3; 
replace dtc5=1000000 if R1861==5; 
replace dtc5=200000 if R1861==8|R1861==9;
replace dtc5=dtc5/`divide'; // convert into annual variable;


keep HHID PN doop5 ddrugc5 dmedc5 dtc5 dmedicaid5; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
drop R* F*; 
summ; 
sort HHID PN; 
sleep 1000;  save `saved'exit, replace;  

use `saved'exit;
merge HHID PN using `saved'exitw2;
drop _merge;

sort HHID PN; 
merge HHID PN using `wave3d'wave3exit;
drop _merge;
***************************************************************************************************************************;
*******************************************************;
*Something interesting about wave 6 is that the Code Book on the HRS website identifies;
*a question differently than the dictonary file;
*thus I will noting these changes throughtout the program;
*******************************************************;
************************Wave VI************************;

clear; 
use `wave6d'x02N_R;

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*SN106=AMT PAID O-O-P HOSPITAL COSTS;
*SN119=AMT PAID O-O-P NURSING HOME;
*SN328=AMT O-O-P COSTS - HOSPICE;
*SN156=AMT PAY O-O-P FOR DOC VISITS;
*SN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*SN194=AMT PAY O-O-P HOME HEALTH SVC;
*SN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*SN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*SN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES;


*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;
*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXprogram define imputethis;
program define imputethis;

egen recipgrp = group(lowervalue uppervalue);
tab recipgrp;
egen numgroup = max(recipgrp);
local num = numgroup[100];
display `num';
sum uppervalue;
local maxup = r(max);

gen exactvalueimpute=.;

*imputation algorithm here*****************************;

local ii =1;
while `ii' <= `num' {;

*first get upper and lower bounds ;
gen mygroup=1;
replace mygroup=0 if recipgrp == `ii';

sum recipgrp if recipgrp == `ii';

sort mygroup;

local mymin= lowervalue[1];
local mymax= uppervalue[1];

qui sum exactvalue if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;
local max = r(N); * number of "donors";

qui sum exactvalue if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
local max2 = r(N); *number of "recipients";

gen sortflag = 1;
replace sortflag = 0 if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
gen sortflag2 = 1;
replace sortflag2 = 0 if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;

sort sortflag sortflag2  HHID PN; 

	local i=1;
	while `i' <= `max2' {;
	  local i2 = ceil(uniform()*`max');


if (`max'>0 & `max'<999999999) {;
	  qui replace exactvalueimpute = exactvalue[`i2'] in `i';
};
if (`max'<1 |  `max'>999999998) {;
	  qui replace exactvalueimpute = sqrt((lowervalue+10)*uppervalue) in `i' if uppervalue~=`maxup';
	  qui replace exactvalueimpute = lowervalue in `i' if uppervalue==`maxup';
 
display `max2';
display `max';
sum mygroup;

};


*};
	  local i = `i' + 1;
	};



drop mygroup sortflag sortflag2;
local ii = `ii' + 1;
};

replace exactvalue=exactvalueimpute if mmiss==1;
replace exactvalue=0 if mmiss==.;
sort mmiss;
by mmiss: sum exactvalue;

drop mmiss recipgrp numgroup exactvalueimpute;


end;

*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;
*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;

* some code useful for debugging;
*if `mymin'>5000 & `mymax'<10000 {;
*	display `max2';
*	display `max';
*	display `i2';
*aorder;
*bomb;

*gen Z=0;
*if `mymin'>5000 & `mymax'<10000 & Z==1{;
*sum recipgrp;
*if recipgrp==9 & Z==1 {;
*	display `max2';
*	display `max';
*	display `i2';
*aorder;
*bomb;
*};



********************** impute SN106 using brackets ***********;

replace SN106=100000 if SN106 ==400000; // results sensitive to one guy  really disturbing;

gen mmiss=.;
replace mmiss=0 if SN106>-100 & SN106<999001; // donor group;
replace mmiss=1 if SN106>999000 & SN106<1999001; // missing variable code;

gen exactvalue=SN106;
gen lowervalue=SN107;
gen uppervalue=SN108;

imputethis;
replace SN106=exactvalue;




********************** impute SN119 using brackets ***********;

gen mmiss=.;
replace mmiss=0 if SN119>-100 & SN119<999001; // donor group;
replace mmiss=1 if SN119>999000 & SN119<1999001; // missing variable code;

replace exactvalue=SN119;
replace lowervalue=SN120;
replace uppervalue=SN121;

imputethis;
replace SN119=exactvalue;

********************** impute SN328 using brackets ***********;

gen mmiss=.;
replace mmiss=0 if SN328>-100 & SN328<9901; // donor group;
replace mmiss=1 if SN328>9990 & SN328<19001; // missing variable code;

replace exactvalue=SN328;
replace lowervalue=SN329;
replace uppervalue=SN330;

imputethis;
replace SN328=exactvalue;

********************** impute SN156 using brackets ***********;
replace SN156=50000 if SN156==150000;
gen mmiss=.;
replace mmiss=0 if SN156>-100 & SN156<999001; // donor group;
replace mmiss=1 if SN156>999000 & SN156<1999001; // missing variable code;

replace exactvalue=SN156;
replace lowervalue=SN157;
replace uppervalue=SN158;

imputethis;


tab SN156;
tab SN157 SN158;
*exit;


replace SN156=exactvalue;

********************** impute SN194 using brackets ***********;

replace SN194=SN194*10 if (SN194>99900 & SN194<199901); // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if SN194>-100 & SN194<999001; // donor group;
replace mmiss=1 if SN194>999000 & SN194<1999001; // missing variable code;

replace exactvalue=SN194;
replace lowervalue=SN195;
replace uppervalue=SN196;

imputethis;
replace SN194=exactvalue;


********************** impute SN239 using brackets ***********;

replace SN239=SN239*100 if (SN239>9900 & SN239<19901); // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if SN239>-100 & SN239<999001; // donor group;
replace mmiss=1 if SN239>990000 & SN239<1999001; // missing variable code;

replace exactvalue=SN239;
replace lowervalue=SN246;
replace uppervalue=SN247;

imputethis;
replace SN239=exactvalue;


********************** impute SN333 using brackets ***********;

replace SN333=SN333*10 if (SN333>99900 & SN333<199001); // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if SN333>-100 & SN333<999001; // donor group;
replace mmiss=1 if SN333>990000 & SN333<1999001; // missing variable code;

replace exactvalue=SN333;
replace lowervalue=SN334;
replace uppervalue=SN335;

imputethis;
replace SN333=exactvalue;


********************** impute SN338 using brackets ***********;

replace SN338=SN338*10 if (SN338>99900 & SN338<199001);// this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if SN338>-100 & SN338<999001; // donor group;
replace mmiss=1 if SN338>990000 & SN338<1999001; // missing variable code;

replace exactvalue=SN338;
replace lowervalue=SN339;
replace uppervalue=SN340;

imputethis;
replace SN338=exactvalue;

gen doop6=SN106+SN119+SN328+SN156+SN194+SN239+SN333+SN338;

replace doop6=doop6/`divide';


********************** impute SN180 using brackets ***********;

replace SN180=SN180*100 if (SN180>9900 & SN180<10001); // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if SN180>-100 & SN180<990001; // donor group;
replace mmiss=1 if SN180>990000 & SN180<1990001; //missing variable code;

replace exactvalue=SN180;
replace lowervalue=SN181;
replace uppervalue=SN182;

imputethis;
replace SN180=exactvalue;


*Jon: Here I generate the disaggregated OOP variables. ;
gen ddrugc6=SN180*12; // yearly out-of-pocket drug costs;
gen dhospc6=SN106/`divide';
gen dnursc6=SN119/`divide';
gen ddocc6= SN156/`divide';
gen dhhsc6=SN194/`divide';
gen dothels6=(SN239+SN333+SN338+SN328)/`divide';
 
sum SN106 SN119 SN328 SN156 SN194 SN239 SN332 SN338 doop6 ddrugc6;


keep HHID PN doop6 ddrugc6 dhospc6 dnursc6 ddocc6 dhhsc6 dothels6; 



sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave6d'x02N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid6=9;
replace dmedicaid6=1 if SN005==1;
replace dmedicaid6=0 if SN005==5;

sum SN014 SN040_1 SN040_2 SN040_3 SN080 SN081;

replace SN014=0 if (SN014==.|SN014>990);
replace SN040_1=0 if (SN040_1==.|SN040_1>990);
replace SN040_2=0 if (SN040_2==.|SN040_2>990);
replace SN040_3=0 if (SN040_3==.|SN040_3>990);

replace SN080=0 if (SN080==.|SN080>990);
replace SN081=0 if (SN081==.|SN081>990);

gen medicare=SN014;
gen private=SN040_1+SN040_2+SN040_3;
gen privateannual=private*12;


gen LTC=(SN080+SN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem6=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc6=doop6+ddrugc6+diprem6;
sum ddrugc6 dmedc6 diprem6;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave6d'x02N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen topcost=SN223;
replace topcost=(SN222*3) if SN223>(3*SN222);


gen dtcx=sqrt(SN222*SN223);
gen dtc6=(SN222+topcost)/2;  // this needs to be fixed--it also  needs to be divided by `divide';

sum dtc*;
replace dtc6=dtcx;


replace dtc6=dtc6/`divide';

sum dtc6;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop SN*;

sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
summ;

drop _all;



************************Wave VII************************;

clear; 
use `wave7d'x04N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*TN106=AMT PAID O-O-P HOSPITAL COSTS;
*TN119=AMT PAID O-O-P NURSING HOME;
*TN328=AMT O-O-P COSTS - HOSPICE;
*TN156=AMT PAY O-O-P FOR DOC VISITS;
*TN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*TN194=AMT PAY O-O-P HOME HEALTH SVC;
*TN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*TN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*TN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES;




/*
gen impute=0;
replace impute=1 if TN106>99900;
gen nocost=0;
replace nocost=1 if TN099==5|TN102==1;

sort nocost;
by nocost: sum nocost TN106;
tab TN106 if nocost==1;

exit;

gen guess=0;
replace guess=1 if TN107==0 & TN108>100000; * these are the guys to have med X, but are really NA/DK;

sum TN106 TN107 TN108;
replace TN106=0 if (TN106==.|TN106>99900); 
egen mymin=min(TN108/5) if (TN108~=0 & TN108~=.);
egen mymax=max(TN107) if TN107~=.;
replace TN107=mymin if TN107==0; drop mymin;
replace TN108=mymax if TN108>100000 & TN108~=.; drop mymax;
replace TN106=sqrt(TN107*TN108) if (TN107~=. & TN108~=.);
replace TN106=3000 if guess==1;
drop guess nocost impute;
*/


********************** impute TN106 using brackets ***********;

replace TN108=99000 if TN108>99000 & TN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if TN106>-100 & TN106<99901; // donor group;
replace mmiss=1 if TN106>99900 & TN106<199901;// missing variable code;

gen exactvalue=TN106;
gen lowervalue=TN107;
gen uppervalue=TN108;

imputethis;

replace TN106=exactvalue;

/*
tab TN120 TN121;
gen guess = 0;
replace guess = 1 if TN120 == 0 & TN121 > 100000;
sum TN119 TN120 TN121;
replace TN119=0 if (TN119==.|TN119>999000); 
egen mymin=min(TN121/5) if (TN121~=0 & TN121~=.);
egen mymax=max(TN120) if TN120~=.;
replace TN120=mymin if TN120==0; drop mymin;
replace TN121=mymax if TN121>100000 & TN121~=.; drop mymax;
replace TN119=sqrt(TN120*TN121) if (TN121~=. & TN120~=.);
replace TN119 = 30000 if guess == 1;
sum TN119 TN120 TN121;
drop guess;

*/

********************** impute TN119 using brackets ***********;
replace TN121=999000 if TN121>999000 & TN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace TN119=300000 if TN119>300000 & TN119<995000; // super ad hoc;

replace TN120=0 if TN120==. & TN119==999998;      // fix annoying quirk in data;
replace TN121=999000 if TN121==. & TN119==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TN119>-100 & TN119<999001; // donor group;
replace mmiss=1 if TN119>999000 & TN119<1999001; // missing variable code;

replace exactvalue=TN119;
replace lowervalue=TN120;
replace uppervalue=TN121;

imputethis;
replace TN119=exactvalue;

/*
tab TN329 TN330;
gen guess = 0;
replace guess = 1 if TN329 == 0 & TN330 > 100000;
gen imp = 0;
replace imp = 1 if TN328 > 99990;
replace TN328=0 if (TN328==.|TN328>99990); 
egen mymin=min(TN330/50) if (TN330~=0 & TN330~=.);
egen mymax=max(TN329) if TN329~=.;
replace TN329=mymin if TN329==0; drop mymin;
replace TN330=mymax if TN330>100000 & TN330~=.; drop mymax;
replace TN328=sqrt(TN329*TN330) if (TN329~=. & TN330~=.);
replace TN328 = 7500 if guess == 1;
sort imp;
by imp: sum TN328 TN329 TN330;
drop guess imp;
*/


********************** impute TN328 using brackets ***********;
replace TN330=99000 if TN330>99000 & TN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if TN328>-100 & TN328<99991; // donor group;
replace mmiss=1 if TN328>99990 & TN328<190001; // missing variable code;

replace exactvalue=TN328;
replace lowervalue=TN329;
replace uppervalue=TN330;

imputethis;
replace TN328=exactvalue;


/*
tab TN157 TN158;
sum TN156;
gen guess = 0;
replace guess = 1 if TN157 == 0 & TN158 > 100000;
gen imp = 0;
replace imp = 1 if TN156 > 99990;
replace TN156=0 if (TN156==.|TN156>99900); 
egen mymin=min(TN158/5) if (TN158~=0 & TN158~=.);
egen mymax=max(TN157) if TN157~=.;
replace TN157=mymin if TN157==0; drop mymin;
replace TN158=mymax if TN158>100000 & TN158~=.; drop mymax;
replace TN158=20000 if TN158==200000 & TN157==5001; * this is a super-ad hoc thing to deal with a data screw-up;
replace TN156=sqrt(TN157*TN158) if (TN157~=. & TN158~=.);
replace TN156 = 865 if guess == 1;
sort imp;
by imp: sum TN156 TN157 TN158;
drop imp guess;

*/


********************** impute TN156 using brackets ***********;

replace TN158=99000 if TN158>99000 & TN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if TN156>-100 & TN156<99901;//donor group;
replace mmiss=1 if TN156>99900 & TN156<199001; // missing variable code;

replace exactvalue=TN156;
replace lowervalue=TN157;
replace uppervalue=TN158;

imputethis;
replace TN156=exactvalue;



/*


tab TN195 TN196;
sum TN194;
gen guess = 0;
replace guess = 1 if TN195 == 0 & TN196 > 100000;
gen imp = 0;
replace imp = 1 if TN194 > 99990;
replace TN194=0 if (TN194==.|TN194>99900); 
egen mymin=min(TN196/5) if (TN196~=0 & TN196~=.);
egen mymax=max(TN195) if TN195~=.;
replace TN195=mymin if TN195==0; drop mymin;
replace TN196=mymax if TN196>100000 & TN196~=.; drop mymax;
replace TN194=sqrt(TN195*TN196) if (TN195~=. & TN196~=.);
replace TN194 = 3300 if guess == 1;
sort imp;
by imp: sum TN194 TN195 TN196;
drop guess imp;

*/






********************** impute TN194 using brackets ***********;

replace TN196=99000 if TN196>99000 & TN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace TN194=TN194*10 if (TN194>99000 & TN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace TN195=0 if TN195==. & TN194==99998;      // fix annoying quirk in data;
replace TN196=999000 if TN196==. & TN194==99998;//fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TN194>-100 & TN194<99901; // donor group;
replace mmiss=1 if TN194>99900 & TN194<1999001; // missing variable code;

replace exactvalue=TN194;
replace lowervalue=TN195;
replace uppervalue=TN196;

imputethis;
replace TN194=exactvalue;



/*

tab TN246 TN247;
sum TN239;
gen guess = 0;
replace guess = 1 if TN246 == 0 & TN247 > 100000;
gen imp = 0;
replace imp = 1 if TN239 > 99990;
replace TN239=0 if (TN239==.|TN239>99900); 
egen mymin=min(TN247/5) if (TN247~=0 & TN247~=.);
egen mymax=max(TN246) if TN246~=.;
replace TN246=mymin if TN246==0; drop mymin;
replace TN247=mymax if TN247>100000 & TN247~=.; drop mymax;
replace TN239=sqrt(TN246*TN247) if (TN246~=. & TN247~=.);
replace TN239 = 930 if guess == 1;
sort imp;
by imp: sum TN239 TN246 TN247;
drop imp guess;
*/




********************** impute TN239 using brackets ***********;
replace TN247=99000 if TN247>99000 & TN247<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace TN246=0 if TN246==. & TN239==99998;      // fix annoying quirk in data;
replace TN247=999000 if TN247==. & TN239==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TN239>-100 & TN239<99991; // donor group;
replace mmiss=1 if TN239>99990 & TN239<1999001; // missing variable code;

replace exactvalue=TN239;
replace lowervalue=TN246;
replace uppervalue=TN247;

imputethis;
replace TN239=exactvalue;

/*
tab TN334 TN335;
sum TN333;
gen guess = 0;
replace guess = 1 if TN334 == 0 & TN335 > 100000;
gen imp = 0;
replace imp = 1 if TN333 > 99990;
replace TN333=0 if (TN333==.|TN333>99900); 
egen mymin=min(TN335/5) if (TN335~=0 & TN335~=.);
egen mymax=max(TN334) if TN334~=.;
replace TN334=mymin if TN334==0; drop mymin;
replace TN335=mymax if TN335>100000 & TN335~=.; drop mymax;
replace TN333=sqrt(TN334*TN335) if (TN334~=. & TN335~=.);
* There was actually no need for the "Guess" or mymax on this one;
sum TN333 TN334 TN335;
sum TN333 if TN335~=.;
sum TN333 if TN335==. & TN333~=0;
drop guess imp;
*/


********************** impute TN333 using brackets ***********;
replace TN335=99000 if TN335>99000 & TN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace TN333=TN333*10 if (TN333>99900 & TN333<199001); * this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if TN333>-100 & TN333<99001; // donor group;
replace mmiss=1 if TN333>99000 & TN333<199901; // missing variable code;

replace exactvalue=TN333;
replace lowervalue=TN334;
replace uppervalue=TN335;

imputethis;
replace TN333=exactvalue;


/*
tab TN339 TN340;
sum TN338;
gen guess = 0;
replace guess = 1 if TN339 == 0 & TN340 > 100000;
gen imp = 0;
replace imp = 1 if TN338 > 999900;
replace TN338=0 if (TN338==.|TN338>999000);
egen mymin=min(TN340/5) if (TN340~=0 & TN340~=.);
egen mymax=max(TN339) if TN339~=.;
replace TN339=mymin if TN339==0; drop mymin;
replace TN340=mymax if TN340>100000 & TN340~=.; drop mymax;
replace TN338=sqrt(TN339*TN340) if (TN339~=. & TN340~=.);
replace TN338 = 5300 if guess == 1;
sort imp;
by imp: sum TN338 TN339 TN340;
sum TN338 if TN340~=.;
sum TN338 if TN340==. & TN338~=0;
drop guess imp;
*/


********************** impute TN338 using brackets ***********;
replace TN340=200000 if TN340>200000 & TN340<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace TN338=TN338*10 if (TN338>999000 & TN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace TN339=0 if TN339==. & TN338==999998;      // fix annoying quirk in data;
replace TN340=999000 if TN340==. & TN338==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TN338>-100 & TN338<9990001; // donor group;
replace mmiss=1 if TN338>999000 & TN338<1999001; // missing variable code;

replace exactvalue=TN338;
replace lowervalue=TN339;
replace uppervalue=TN340;

imputethis;
replace TN338=exactvalue;




gen doop7=TN106+TN119+TN328+TN156+TN194+TN239+TN333+TN338;

replace doop7=doop7/`divide';
tab TN338;

/*
tab TN181 TN182;
sum TN180;
gen guess = 0;
replace guess = 1 if TN181 == 0 & TN182 > 100000;
gen imp = 0;
replace imp = 1 if TN180 > 9990;
replace TN180=0 if (TN180==.|TN180>9990);
egen mymin=min(TN182) if (TN182~=0 & TN182~=.);
egen mymax=max(TN181) if TN181~=.;
replace TN181=mymin if TN181==0; drop mymin;
replace TN182=mymax if TN182>100000 & TN182~=.; drop mymax;
replace TN180=sqrt(TN181*TN182) if (TN181~=. & TN182~=.);
replace TN180 = 230 if guess == 1;
sort imp;
by imp: sum TN180 TN181 TN182;
sum TN180 if TN182~=.;
sum TN180 if TN182==. & TN180~=0;
*/


********************** impute TN180 using brackets ***********;
replace TN182=9000 if TN182>9000 & TN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace TN181=0 if TN181==. & TN180==9998;      // fix annoying quirk in data;
replace TN182=9000 if TN182==. & TN180==9998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TN180>-100 & TN180<9990; // donor group;
replace mmiss=1 if TN180>9990 & TN180<19991; //missing variable code;

replace exactvalue=TN180;
replace lowervalue=TN181;
replace uppervalue=TN182;

imputethis;

sum exactvalue TN180 if TN181==.;
sum exactvalue TN180 if TN181~=.;
sum exactvalue TN180 if TN181==. & exactvalue~=0;
*exit;

replace TN180=exactvalue;




gen ddrugc7=TN180*12; // yearly out-of-pocket drug costs;
gen dhospc7=TN106/`divide';
gen dnursc7=TN119/`divide';
gen ddocc7= TN156/`divide';
gen dhhsc7=TN194/`divide';
gen dothels7=(TN239+TN333+TN338+TN328)/`divide';
 
sum TN106 TN119 TN328 TN156 TN194 TN239 TN332 TN338 doop7 ddrugc7 dhospc7 dnursc7 ddocc7 dhhsc7 dothels7;


keep HHID PN doop7 ddrugc7 dhospc7 dnursc7 ddocc7 dhhsc7 dothels7; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 



keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave7d'x04N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid7=9;
replace dmedicaid7=1 if TN005==1;
replace dmedicaid7=0 if TN005==5;

sum TN014 TN040_1 TN040_2 TN040_3 TN080 TN081;

replace TN014=0 if (TN014==.|TN014>990);
replace TN040_1=0 if (TN040_1==.|TN040_1>9990);
replace TN040_2=0 if (TN040_2==.|TN040_2>990);
replace TN040_3=0 if (TN040_3==.|TN040_3>990);

replace TN080=0 if (TN080==.|TN080>990);
replace TN081=0 if (TN081==.|TN081>990);

gen medicare=TN014;
gen private=TN040_1+TN040_2+TN040_3;
gen privateannual=private*12;


gen LTC=(TN080+TN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem7=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc7=doop7+ddrugc7+diprem7;
sum ddrugc7 dmedc7 diprem7;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000;  save `saved'exit, replace; 
clear; 

use `wave7d'x04N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=TN223;
*replace topcost=(TN222*3) if TN223>(3*TN222);


*gen dtcx=sqrt(TN222*TN223);
*gen dtc7=(TN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc7=dtcx;


*replace dtc7=dtc7/`divide';

*sum dtc7;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop TN*;

sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
summ;
drop _all;



************************Wave VIII************************;

clear; 
use `wave8d'x06N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*UN106=AMT PAID O-O-P HOSPITAL COSTS;
*UN119=AMT PAID O-O-P NURSING HOME;
*UN328=AMT O-O-P COSTS - HOSPICE;
*UN156=AMT PAY O-O-P FOR DOC VISITS;
*UN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*UN194=AMT PAY O-O-P HOME HEALTH SVC;
*UN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*UN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*UN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES;




/*
gen impute=0;
replace impute=1 if UN106>9999900;
gen nocost=0;
replace nocost=1 if UN099==5|UN102==1;

sort nocost;
by nocost: sum nocost UN106;
tab UN106 if nocost==1;

gen guess=0;
replace guess=1 if UN107==0 & UN108>100000; * these are the guys to have med X, but are really NA/DK;

sum UN106 UN107 UN108;
replace UN106=0 if (UN106==.|UN106>9999900); 
egen mymin=min(UN108/5) if (UN108~=0 & UN108~=.);
egen mymax=max(UN107) if UN107~=.;
replace UN107=mymin if UN107==0; drop mymin;
replace UN108=mymax if UN108>100000 & UN108~=.; drop mymax;
replace UN106=sqrt(UN107*UN108) if (UN107~=. & UN108~=.);
replace UN106=3000 if guess==1;
drop guess nocost impute;
*/


********************** impute UN106 using brackets ***********;

replace UN108=200000 if UN108>9999000 & UN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if UN106>-100 & UN106<9990001; // donor group;
replace mmiss=1 if UN106>9990000 & UN106<19990001; // missing variable code;

gen exactvalue=UN106;
gen lowervalue=UN107;
gen uppervalue=UN108;

imputethis;
replace UN106=exactvalue;

/*

tab UN120 UN121;
gen guess = 0;
replace guess = 1 if UN120 == 0 & UN121 > 100000;
sum UN119 UN120 UN121;
replace UN119=0 if (UN119==.|UN119>999000); 
egen mymin=min(UN121/5) if (UN121~=0 & UN121~=.);
egen mymax=max(UN120) if UN120~=.;
replace UN120=mymin if UN120==0; drop mymin;
replace UN121=mymax if UN121>100000 & UN121~=.; drop mymax;
replace UN119=sqrt(UN120*UN121) if (UN121~=. & UN120~=.);
replace UN119 = 30000 if guess == 1;
sum UN119 UN120 UN121;
drop guess;

*/

********************** impute UN119 using brackets ***********;
replace UN121=999000 if UN121>999000 & UN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace UN120=0 if UN120==. & UN119==9999998;      // fix annoying quirk in data;
replace UN121=999000 if UN121==. & UN119==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UN119>-100 & UN119<9990001; // donor group;
replace mmiss=1 if UN119>9990000 & UN119<19999001; // missing variable code;

replace exactvalue=UN119;
replace lowervalue=UN120;
replace uppervalue=UN121;

imputethis;
replace UN119=exactvalue;

/*
tab UN329 UN330;
gen guess = 0;
replace guess = 1 if UN329 == 0 & UN330 > 100000;
gen imp = 0;
replace imp = 1 if UN328 > 99990;
replace UN328=0 if (UN328==.|UN328>99990); 
egen mymin=min(UN330/50) if (UN330~=0 & UN330~=.);
egen mymax=max(UN329) if UN329~=.;
replace UN329=mymin if UN329==0; drop mymin;
replace UN330=mymax if UN330>100000 & UN330~=.; drop mymax;
replace UN328=sqrt(UN329*UN330) if (UN329~=. & UN330~=.);
replace UN328 = 7500 if guess == 1;
sort imp;
by imp: sum UN328 UN329 UN330;
drop guess imp;
*/


********************** impute UN328 using brackets ***********;
replace UN330=99000 if UN330>999000 & UN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if UN328>-100 & UN328<9999991; // donor group;
replace mmiss=1 if UN328>9999990 & UN328<19990001; // missing variable code;

replace exactvalue=UN328;
replace lowervalue=UN329;
replace uppervalue=UN330;

imputethis;
replace UN328=exactvalue;


/*

tab UN157 UN158;
sum UN156;
gen guess = 0;
replace guess = 1 if UN157 == 0 & UN158 > 100000;
gen imp = 0;
replace imp = 1 if UN156 > 99990;
replace UN156=0 if (UN156==.|UN156>99900); 
egen mymin=min(UN158/5) if (UN158~=0 & UN158~=.);
egen mymax=max(UN157) if UN157~=.;
replace UN157=mymin if UN157==0; drop mymin;
replace UN158=mymax if UN158>100000 & UN158~=.; drop mymax;
replace UN158=20000 if UN158==200000 & UN157==5001; * this is a super-ad hoc thing to deal with a data screw-up;
replace UN156=sqrt(UN157*UN158) if (UN157~=. & UN158~=.);
replace UN156 = 865 if guess == 1;
sort imp;
by imp: sum UN156 UN157 UN158;
drop imp guess;

*/


********************** impute UN156 using brackets ***********;

replace UN158=99000 if UN158>999000 & UN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if UN156>-100 & UN156<9999901; // donor group;
replace mmiss=1 if UN156>9999900 & UN156<19999001; // missing variable code;

replace exactvalue=UN156;
replace lowervalue=UN157;
replace uppervalue=UN158;

imputethis;
replace UN156=exactvalue;


/*
tab UN195 UN196;
sum UN194;
gen guess = 0;
replace guess = 1 if UN195 == 0 & UN196 > 100000;
gen imp = 0;
replace imp = 1 if UN194 > 99990;
replace UN194=0 if (UN194==.|UN194>99900); 
egen mymin=min(UN196/5) if (UN196~=0 & UN196~=.);
egen mymax=max(UN195) if UN195~=.;
replace UN195=mymin if UN195==0; drop mymin;
replace UN196=mymax if UN196>100000 & UN196~=.; drop mymax;
replace UN194=sqrt(UN195*UN196) if (UN195~=. & UN196~=.);
replace UN194 = 3300 if guess == 1;
sort imp;
by imp: sum UN194 UN195 UN196;
drop guess imp;
*/



********************** impute UN194 using brackets ***********;

replace UN196=99000 if UN196>99000 & UN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace UN194=UN194*10 if (UN194>99000 & UN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace UN195=0 if UN195==. & UN194==999998;      // fix annoying quirk in data;
replace UN196=999000 if UN196==. & UN194==999998;  //fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UN194>-100 & UN194<999901; // donor group;
replace mmiss=1 if UN194>999900 & UN194<19999001; // missing variable code;

replace exactvalue=UN194;
replace lowervalue=UN195;
replace uppervalue=UN196;

imputethis;
replace UN194=exactvalue;



/*


tab UN246 UN247;
sum UN239;
gen guess = 0;
replace guess = 1 if UN246 == 0 & UN247 > 100000;
gen imp = 0;
replace imp = 1 if UN239 > 99990;
replace UN239=0 if (UN239==.|UN239>99900); 
egen mymin=min(UN247/5) if (UN247~=0 & UN247~=.);
egen mymax=max(UN246) if UN246~=.;
replace UN246=mymin if UN246==0; drop mymin;
replace UN247=mymax if UN247>100000 & UN247~=.; drop mymax;
replace UN239=sqrt(UN246*UN247) if (UN246~=. & UN247~=.);
replace UN239 = 930 if guess == 1;
sort imp;
by imp: sum UN239 UN246 UN247;
drop imp guess;
*/




********************** impute UN239 using brackets ***********;
replace UN247=99000 if UN247>999000 & UN247<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace UN246=0 if UN246==. & UN239==9999998;      // fix annoying quirk in data;
replace UN247=999000 if UN247==. & UN239==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UN239>-100 & UN239<9999991; // donor group;
replace mmiss=1 if UN239>9999990 & UN239<19999001; // missing variable code;

replace exactvalue=UN239;
replace lowervalue=UN246;
replace uppervalue=UN247;

imputethis;
replace UN239=exactvalue;

/*
tab UN334 UN335;
sum UN333;
gen guess = 0;
replace guess = 1 if UN334 == 0 & UN335 > 100000;
gen imp = 0;
replace imp = 1 if UN333 > 99990;
replace UN333=0 if (UN333==.|UN333>99900); 
egen mymin=min(UN335/5) if (UN335~=0 & UN335~=.);
egen mymax=max(UN334) if UN334~=.;
replace UN334=mymin if UN334==0; drop mymin;
replace UN335=mymax if UN335>100000 & UN335~=.; drop mymax;
replace UN333=sqrt(UN334*UN335) if (UN334~=. & UN335~=.);
* There was actually no need for the "Guess" or mymax on this one;
sum UN333 UN334 UN335;
sum UN333 if UN335~=.;
sum UN333 if UN335==. & UN333~=0;
drop guess imp;
*/


********************** impute UN333 using brackets ***********;
replace UN335=99000 if UN335>99000 & UN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace UN333=UN333*10 if (UN333>99900 & UN333<199001); * this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if UN333>-100 & UN333<999001; // donor group;
replace mmiss=1 if UN333>999000 & UN333<1999901; // missing variable code;

replace exactvalue=UN333;
replace lowervalue=UN334;
replace uppervalue=UN335;

imputethis;
replace UN333=exactvalue;


/*
tab UN339 UN340;
sum UN338;
gen guess = 0;
replace guess = 1 if UN339 == 0 & UN340 > 100000;
gen imp = 0;
replace imp = 1 if UN338 > 999900;
replace UN338=0 if (UN338==.|UN338>999000);
egen mymin=min(UN340/5) if (UN340~=0 & UN340~=.);
egen mymax=max(UN339) if UN339~=.;
replace UN339=mymin if UN339==0; drop mymin;
replace UN340=mymax if UN340>100000 & UN340~=.; drop mymax;
replace UN338=sqrt(UN339*UN340) if (UN339~=. & UN340~=.);
replace UN338 = 5300 if guess == 1;
sort imp;
by imp: sum UN338 UN339 UN340;
sum UN338 if UN340~=.;
sum UN338 if UN340==. & UN338~=0;
drop guess imp;
*/


********************** impute UN338 using brackets ***********;
replace UN340=200000 if UN340>200000 & UN340<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace UN338=UN338*10 if (UN338>999000 & UN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace UN339=0 if UN339==. & UN338==999998;      //fix annoying quirk in data;
replace UN340=999000 if UN340==. & UN338==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UN338>-100 & UN338<9990001; // donor group;
replace mmiss=1 if UN338>999000 & UN338<1999001; // missing variable code;

replace exactvalue=UN338;
replace lowervalue=UN339;
replace uppervalue=UN340;

imputethis;
replace UN338=exactvalue;

gen doop8=UN106+UN119+UN328+UN156+UN194+UN239+UN333+UN338;


replace doop8=doop8/`divide';
tab UN338;


/*
tab UN181 UN182;
sum UN180;
gen guess = 0;
replace guess = 1 if UN181 == 0 & UN182 > 100000;
gen imp = 0;
replace imp = 1 if UN180 > 9990;
replace UN180=0 if (UN180==.|UN180>9990);
egen mymin=min(UN182) if (UN182~=0 & UN182~=.);
egen mymax=max(UN181) if UN181~=.;
replace UN181=mymin if UN181==0; drop mymin;
replace UN182=mymax if UN182>100000 & UN182~=.; drop mymax;
replace UN180=sqrt(UN181*UN182) if (UN181~=. & UN182~=.);
replace UN180 = 230 if guess == 1;
sort imp;
by imp: sum UN180 UN181 UN182;
sum UN180 if UN182~=.;
sum UN180 if UN182==. & UN180~=0;
*/

********************** impute UN180 using brackets ***********;
replace UN182=9000 if UN182>9000 & UN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace UN181=0 if UN181==. & UN180==99998;      // fix annoying quirk in data;
replace UN182=9000 if UN182==. & UN180==99998; // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UN180>-100 & UN180<99990; // donor group;
replace mmiss=1 if UN180>99990 & UN180<199991; // missing variable code;

replace exactvalue=UN180;
replace lowervalue=UN181;
replace uppervalue=UN182;

imputethis;

*sum exactvalue UN180 if UN181==.;
*sum exactvalue UN180 if UN181~=.;
*sum exactvalue UN180 if UN181==. & exactvalue~=0;
*exit;

replace UN180=exactvalue;

gen ddrugc8=UN180*12; // yearly out-of-pocket drug costs;
gen dhospc8=UN106/`divide';
gen dnursc8=UN119/`divide';
gen ddocc8= UN156/`divide';
gen dhhsc8=UN194/`divide';
gen dothels8=(UN239+UN333+UN338+UN328)/`divide';
 
sum UN106 UN119 UN328 UN156 UN194 UN239 UN332 UN338 doop8 ddrugc8 dhospc8 dnursc8 ddocc8 dhhsc8 dothels8;


keep HHID PN doop8 ddrugc8 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave8d'x06N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid8=9;
replace dmedicaid8=1 if UN005==1;
replace dmedicaid8=0 if UN005==5;

sum UN014 UN040_1 UN040_2 UN040_3 UN080 UN081;

replace UN014=0 if (UN014==.|UN014>990);
replace UN040_1=0 if (UN040_1==.|UN040_1>990);
replace UN040_2=0 if (UN040_2==.|UN040_2>990);
replace UN040_3=0 if (UN040_3==.|UN040_3>990);

replace UN080=0 if (UN080==.|UN080>990);
replace UN081=0 if (UN081==.|UN081>990);

gen medicare=UN014;
gen private=UN040_1+UN040_2+UN040_3;
gen privateannual=private*12;


gen LTC=(UN080+UN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem8=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc8=doop8+ddrugc8+diprem8;
sum ddrugc8 dmedc8 diprem8;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave8d'x06N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=UN223;
*replace topcost=(UN222*3) if UN223>(3*UN222);


*gen dtcx=sqrt(UN222*UN223);
*gen dtc8=(UN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc8=dtcx;


*replace dtc8=dtc8/`divide';

*sum dtc8;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop UN*;

compress;
sort HHID PN; 
save `saved'exitmedcost, replace;
summ;
drop _all;

************************Wave IX************************;

clear; 
use `wave9d'x08N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*VN106=AMT PAID O-O-P HOSPITAL COSTS;
*VN119=AMT PAID O-O-P NURSING HOME;
*VN328=AMT O-O-P COSTS - HOSPICE;
*VN156=AMT PAY O-O-P FOR DOC VISITS;
*VN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*VN194=AMT PAY O-O-P HOME HEALTH SVC;
*VN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*VN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*VN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES;




/*
gen impute=0;
replace impute=1 if VN106>9999900;
gen nocost=0;
replace nocost=1 if VN099==5|VN102==1;

sort nocost;
by nocost: sum nocost VN106;
tab VN106 if nocost==1;

gen guess=0;
replace guess=1 if VN107==0 & VN108>100000; * these are the guys to have med X, but are really NA/DK;

sum VN106 VN107 VN108;
replace VN106=0 if (VN106==.|VN106>9999900); 
egen mymin=min(VN108/5) if (VN108~=0 & VN108~=.);
egen mymax=max(VN107) if VN107~=.;
replace VN107=mymin if VN107==0; drop mymin;
replace VN108=mymax if VN108>100000 & VN108~=.; drop mymax;
replace VN106=sqrt(VN107*VN108) if (VN107~=. & VN108~=.);
replace VN106=3000 if guess==1;
drop guess nocost impute;
*/


********************** impute VN106 using brackets ***********;

replace VN108=200000 if VN108>9999000 & VN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if VN106>-100 & VN106<9990001; // donor group;
replace mmiss=1 if VN106>9990000 & VN106<19990001; // missing variable code;

gen exactvalue=VN106;
gen lowervalue=VN107;
gen uppervalue=VN108;

imputethis;
replace VN106=exactvalue;

/*

tab VN120 VN121;
gen guess = 0;
replace guess = 1 if VN120 == 0 & VN121 > 100000;
sum VN119 VN120 VN121;
replace VN119=0 if (VN119==.|VN119>999000); 
egen mymin=min(VN121/5) if (VN121~=0 & VN121~=.);
egen mymax=max(VN120) if VN120~=.;
replace VN120=mymin if VN120==0; drop mymin;
replace VN121=mymax if VN121>100000 & VN121~=.; drop mymax;
replace VN119=sqrt(VN120*VN121) if (VN121~=. & VN120~=.);
replace VN119 = 30000 if guess == 1;
sum VN119 VN120 VN121;
drop guess;

*/

********************** impute VN119 using brackets ***********;
replace VN121=999000 if VN121>999000 & VN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace VN120=0 if VN120==. & VN119==9999998;      // fix annoying quirk in data;
replace VN121=999000 if VN121==. & VN119==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VN119>-100 & VN119<9990001; * donor group;
replace mmiss=1 if VN119>9990000 & VN119<19999001; * missing variable code;

replace exactvalue=VN119;
replace lowervalue=VN120;
replace uppervalue=VN121;

imputethis;
replace VN119=exactvalue;

/*
tab VN329 VN330;
gen guess = 0;
replace guess = 1 if VN329 == 0 & VN330 > 100000;
gen imp = 0;
replace imp = 1 if VN328 > 99990;
replace VN328=0 if (VN328==.|VN328>99990); 
egen mymin=min(VN330/50) if (VN330~=0 & VN330~=.);
egen mymax=max(VN329) if VN329~=.;
replace VN329=mymin if VN329==0; drop mymin;
replace VN330=mymax if VN330>100000 & VN330~=.; drop mymax;
replace VN328=sqrt(VN329*VN330) if (VN329~=. & VN330~=.);
replace VN328 = 7500 if guess == 1;
sort imp;
by imp: sum VN328 VN329 VN330;
drop guess imp;
*/


********************** impute VN328 using brackets ***********;
replace VN330=99000 if VN330>999000 & VN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if VN328>-100 & VN328<9999991; // donor group;
replace mmiss=1 if VN328>9999990 & VN328<19990001; // missing variable code;

replace exactvalue=VN328;
replace lowervalue=VN329;
replace uppervalue=VN330;

imputethis;
replace VN328=exactvalue;


/*

tab VN157 VN158;
sum VN156;
gen guess = 0;
replace guess = 1 if VN157 == 0 & VN158 > 100000;
gen imp = 0;
replace imp = 1 if VN156 > 99990;
replace VN156=0 if (VN156==.|VN156>99900); 
egen mymin=min(VN158/5) if (VN158~=0 & VN158~=.);
egen mymax=max(VN157) if VN157~=.;
replace VN157=mymin if VN157==0; drop mymin;
replace VN158=mymax if VN158>100000 & VN158~=.; drop mymax;
replace VN158=20000 if VN158==200000 & VN157==5001; * this is a super-ad hoc thing to deal with a data screw-up;
replace VN156=sqrt(VN157*VN158) if (VN157~=. & VN158~=.);
replace VN156 = 865 if guess == 1;
sort imp;
by imp: sum VN156 VN157 VN158;
drop imp guess;

*/


********************** impute VN156 using brackets ***********;

replace VN158=99000 if VN158>999000 & VN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if VN156>-100 & VN156<9999901; // donor group;
replace mmiss=1 if VN156>9999900 & VN156<19999001; // missing variable code;

replace exactvalue=VN156;
replace lowervalue=VN157;
replace uppervalue=VN158;

imputethis;
replace VN156=exactvalue;


/*
tab VN195 VN196;
sum VN194;
gen guess = 0;
replace guess = 1 if VN195 == 0 & VN196 > 100000;
gen imp = 0;
replace imp = 1 if VN194 > 99990;
replace VN194=0 if (VN194==.|VN194>99900); 
egen mymin=min(VN196/5) if (VN196~=0 & VN196~=.);
egen mymax=max(VN195) if VN195~=.;
replace VN195=mymin if VN195==0; drop mymin;
replace VN196=mymax if VN196>100000 & VN196~=.; drop mymax;
replace VN194=sqrt(VN195*VN196) if (VN195~=. & VN196~=.);
replace VN194 = 3300 if guess == 1;
sort imp;
by imp: sum VN194 VN195 VN196;
drop guess imp;
*/



********************** impute VN194 using brackets ***********;

replace VN196=99000 if VN196>99000 & VN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace VN194=VN194*10 if (VN194>99000 & VN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace VN195=0 if VN195==. & VN194==999998;      // fix annoying quirk in data;
replace VN196=999000 if VN196==. & VN194==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VN194>-100 & VN194<999901; // donor group;
replace mmiss=1 if VN194>999900 & VN194<19999001; // missing variable code;

replace exactvalue=VN194;
replace lowervalue=VN195;
replace uppervalue=VN196;

imputethis;
replace VN194=exactvalue;



/*


tab VN246 VN247;
sum VN239;
gen guess = 0;
replace guess = 1 if VN246 == 0 & VN247 > 100000;
gen imp = 0;
replace imp = 1 if VN239 > 99990;
replace VN239=0 if (VN239==.|VN239>99900); 
egen mymin=min(VN247/5) if (VN247~=0 & VN247~=.);
egen mymax=max(VN246) if VN246~=.;
replace VN246=mymin if VN246==0; drop mymin;
replace VN247=mymax if VN247>100000 & VN247~=.; drop mymax;
replace VN239=sqrt(VN246*VN247) if (VN246~=. & VN247~=.);
replace VN239 = 930 if guess == 1;
sort imp;
by imp: sum VN239 VN246 VN247;
drop imp guess;
*/




********************** impute VN239 using brackets ***********;
replace VN247=99000 if VN247>999000 & VN247<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace VN246=0 if VN246==. & VN239==9999998;      // fix annoying quirk in data;
replace VN247=999000 if VN247==. & VN239==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VN239>-100 & VN239<9999991; // donor group;
replace mmiss=1 if VN239>9999990 & VN239<19999001; // missing variable code;

replace exactvalue=VN239;
replace lowervalue=VN246;
replace uppervalue=VN247;

imputethis;
replace VN239=exactvalue;

/*
tab VN334 VN335;
sum VN333;
gen guess = 0;
replace guess = 1 if VN334 == 0 & VN335 > 100000;
gen imp = 0;
replace imp = 1 if VN333 > 99990;
replace VN333=0 if (VN333==.|VN333>99900); 
egen mymin=min(VN335/5) if (VN335~=0 & VN335~=.);
egen mymax=max(VN334) if VN334~=.;
replace VN334=mymin if VN334==0; drop mymin;
replace VN335=mymax if VN335>100000 & VN335~=.; drop mymax;
replace VN333=sqrt(VN334*VN335) if (VN334~=. & VN335~=.);
* There was actually no need for the "Guess" or mymax on this one;
sum VN333 VN334 VN335;
sum VN333 if VN335~=.;
sum VN333 if VN335==. & VN333~=0;
drop guess imp;
*/


********************** impute VN333 using brackets ***********;
replace VN335=99000 if VN335>99000 & VN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace VN333=VN333*10 if (VN333>99900 & VN333<199001); * this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if VN333>-100 & VN333<999001; // donor group;
replace mmiss=1 if VN333>999000 & VN333<1999901; // missing variable code;

replace exactvalue=VN333;
replace lowervalue=VN334;
replace uppervalue=VN335;

imputethis;
replace VN333=exactvalue;


/*
tab VN339 VN340;
sum VN338;
gen guess = 0;
replace guess = 1 if VN339 == 0 & VN340 > 100000;
gen imp = 0;
replace imp = 1 if VN338 > 999900;
replace VN338=0 if (VN338==.|VN338>999000);
egen mymin=min(VN340/5) if (VN340~=0 & VN340~=.);
egen mymax=max(VN339) if VN339~=.;
replace VN339=mymin if VN339==0; drop mymin;
replace VN340=mymax if VN340>100000 & VN340~=.; drop mymax;
replace VN338=sqrt(VN339*VN340) if (VN339~=. & VN340~=.);
replace VN338 = 5300 if guess == 1;
sort imp;
by imp: sum VN338 VN339 VN340;
sum VN338 if VN340~=.;
sum VN338 if VN340==. & VN338~=0;
drop guess imp;
*/


********************** impute VN338 using brackets ***********;
replace VN340=200000 if VN340>200000 & VN340<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace VN338=VN338*10 if (VN338>999000 & VN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace VN339=0 if VN339==. & VN338==999998;      // fix annoying quirk in data;
replace VN340=999000 if VN340==. & VN338==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VN338>-100 & VN338<9990001; // donor group;
replace mmiss=1 if VN338>999000 & VN338<1999001; // missing variable code;

replace exactvalue=VN338;
replace lowervalue=VN339;
replace uppervalue=VN340;

imputethis;
replace VN338=exactvalue;

gen doop9=VN106+VN119+VN328+VN156+VN194+VN239+VN333+VN338;


replace doop9=doop9/`divide';
tab VN338;


/*
tab VN181 VN182;
sum VN180;
gen guess = 0;
replace guess = 1 if VN181 == 0 & VN182 > 100000;
gen imp = 0;
replace imp = 1 if VN180 > 9990;
replace VN180=0 if (VN180==.|VN180>9990);
egen mymin=min(VN182) if (VN182~=0 & VN182~=.);
egen mymax=max(VN181) if VN181~=.;
replace VN181=mymin if VN181==0; drop mymin;
replace VN182=mymax if VN182>100000 & VN182~=.; drop mymax;
replace VN180=sqrt(VN181*VN182) if (VN181~=. & VN182~=.);
replace VN180 = 230 if guess == 1;
sort imp;
by imp: sum VN180 VN181 VN182;
sum VN180 if VN182~=.;
sum VN180 if VN182==. & VN180~=0;
*/

********************** impute VN180 using brackets ***********;
replace VN182=9000 if VN182>9000 & VN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace VN181=0 if VN181==. & VN180==99998;      //fix annoying quirk in data;
replace VN182=9000 if VN182==. & VN180==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VN180>-100 & VN180<99990; // donor group;
replace mmiss=1 if VN180>99990 & VN180<199991; // missing variable code;

replace exactvalue=VN180;
replace lowervalue=VN181;
replace uppervalue=VN182;

imputethis;

*sum exactvalue VN180 if VN181==.;
*sum exactvalue VN180 if VN181~=.;
*sum exactvalue VN180 if VN181==. & exactvalue~=0;
*exit;

replace VN180=exactvalue;

gen ddrugc9=VN180*12; // yearly out-of-pocket drug costs;
gen dhospc9=VN106/`divide';
gen dnursc9=VN119/`divide';
gen ddocc9= VN156/`divide';
gen dhhsc9=VN194/`divide';
gen dothels9=(VN239+VN333+VN338+VN328)/`divide';
 
sum VN106 VN119 VN328 VN156 VN194 VN239 VN332 VN338 doop9 ddrugc9 dhospc9 dnursc9 ddocc9 dhhsc9 dothels9;


keep HHID PN doop9 ddrugc9 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave9d'x08N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid9=9;
replace dmedicaid9=1 if VN005==1;
replace dmedicaid9=0 if VN005==5;

sum VN014 VN040_1 VN040_2 VN040_3 VN080 VN081;

replace VN014=0 if (VN014==.|VN014>990);

replace VN040_1=0 if (VN040_1==.|VN040_1>9000);                                 // one value over 2000
replace VN040_2=0 if (VN040_2==.|VN040_2>990);
replace VN040_3=0 if (VN040_3==.|VN040_3>990);

replace VN080=0 if (VN080==.|VN080>990);
replace VN081=0 if (VN081==.|VN081>990);

gen medicare=VN014;
gen private=VN040_1+VN040_2+VN040_3;
gen privateannual=private*12;


gen LTC=(VN080+VN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem9=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc9=doop9+ddrugc9+diprem9;
sum ddrugc9 dmedc9 diprem9;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave9d'x08N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=VN223;
*replace topcost=(VN222*3) if VN223>(3*VN222);


*gen dtcx=sqrt(VN222*VN223);
*gen dtc9=(VN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc9=dtcx;


*replace dtc9=dtc9/`divide';

*sum dtc9;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop VN*;

compress;
sort HHID PN; 
save `saved'exitmedcost, replace;
summ;

drop _all;



************************Wave X************************;

clear; 
use `wave10d'x10N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*WN106=AMT PAID O-O-P HOSPITAL COSTS;
*WN119=AMT PAID O-O-P NURSING HOME;
*WN328=AMT O-O-P COSTS - HOSPICE;
*WN156=AMT PAY O-O-P FOR DOC VISITS;
*WN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*WN194=AMT PAY O-O-P HOME HEALTH SVC;
*WN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*WN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*WN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES;




/*
gen impute=0;
replace impute=1 if WN106>9999900;
gen nocost=0;
replace nocost=1 if WN099==5|WN102==1;

sort nocost;
by nocost: sum nocost WN106;
tab WN106 if nocost==1;

gen guess=0;
replace guess=1 if WN107==0 & WN108>100000; * these are the guys to have med X, but are really NA/DK;

sum WN106 WN107 WN108;
replace WN106=0 if (WN106==.|WN106>9999900); 
egen mymin=min(WN108/5) if (WN108~=0 & WN108~=.);
egen mymax=max(WN107) if WN107~=.;
replace WN107=mymin if WN107==0; drop mymin;
replace WN108=mymax if WN108>100000 & WN108~=.; drop mymax;
replace WN106=sqrt(WN107*WN108) if (WN107~=. & WN108~=.);
replace WN106=3000 if guess==1;
drop guess nocost impute;
*/


********************** impute WN106 using brackets ***********;

replace WN108=99000 if WN108>9999000 & WN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if WN106>-100 & WN106<99901; // donor group;
replace mmiss=1 if WN106>99901 & WN106<19990001; // missing variable code;

gen exactvalue=WN106;
gen lowervalue=WN107;
gen uppervalue=WN108;

imputethis;
replace WN106=exactvalue;

/*

tab WN120 WN121;
gen guess = 0;
replace guess = 1 if WN120 == 0 & WN121 > 100000;
sum WN119 WN120 WN121;
replace WN119=0 if (WN119==.|WN119>999000); 
egen mymin=min(WN121/5) if (WN121~=0 & WN121~=.);
egen mymax=max(WN120) if WN120~=.;
replace WN120=mymin if WN120==0; drop mymin;
replace WN121=mymax if WN121>100000 & VN121~=.; drop mymax;
replace WN119=sqrt(WN120*WN121) if (WN121~=. & WN120~=.);
replace WN119 = 30000 if guess == 1;
sum WN119 WN120 WVN121;
drop guess;

*/

********************** impute WN119 using brackets ***********;
replace WN121=999000 if WN121>999000 & WN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace WN120=0 if WN120==. & WN119==9999998;      // fix annoying quirk in data;
replace WN121=999000 if WN121==. & WN119==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WN119>-100 & WN119<9990001; // donor group;
replace mmiss=1 if WN119>9990000 & WN119<19999001; // missing variable code;

replace exactvalue=WN119;
replace lowervalue=WN120;
replace uppervalue=WN121;

imputethis;
replace WN119=exactvalue;

/*
tab WN329 WN330;
gen guess = 0;
replace guess = 1 if WN329 == 0 & WN330 > 100000;
gen imp = 0;
replace imp = 1 if WN328 > 99990;
replace WN328=0 if (WN328==.|WN328>99990); 
egen mymin=min(WN330/50) if (WN330~=0 & WN330~=.);
egen mymax=max(WN329) if WN329~=.;
replace WN329=mymin if WN329==0; drop mymin;
replace WN330=mymax if WN330>100000 & WN330~=.; drop mymax;
replace WN328=sqrt(WN329*WN330) if (WN329~=. & VN330~=.);
replace WN328 = 7500 if guess == 1;
sort imp;
by imp: sum WN328 WN329 WN330;
drop guess imp;
*/


********************** impute WN328 using brackets ***********;
replace WN330=99000 if WN330>999000 & WN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if WN328>-100 & WN328<9999991; // donor group;
replace mmiss=1 if WN328>9999990 & WN328<19990001; // missing variable code;

replace exactvalue=WN328;
replace lowervalue=WN329;
replace uppervalue=WN330;

imputethis;
replace WN328=exactvalue;


/*

tab WN157 WN158;
sum WN156;
gen guess = 0;
replace guess = 1 if WN157 == 0 & WN158 > 100000;
gen imp = 0;
replace imp = 1 if WN156 > 99990;
replace WN156=0 if (WN156==.|WN156>99900); 
egen mymin=min(WN158/5) if (WN158~=0 & WN158~=.);
egen mymax=max(WN157) if WN157~=.;
replace WN157=mymin if WN157==0; drop mymin;
replace WN158=mymax if WN158>100000 & WN158~=.; drop mymax;
replace WN158=20000 if WN158==200000 & WN157==5001; * this is a super-ad hoc thing to deal with a data screw-up;
replace WN156=sqrt(WN157*WN158) if (WN157~=. & WN158~=.);
replace WN156 = 865 if guess == 1;
sort imp;
by imp: sum WN156 WN157 WN158;
drop imp guess;

*/


********************** impute WN156 using brackets ***********;

replace WN158=99000 if WN158>999000 & WN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if WN156>-100 & WN156<9999901; // donor group;
replace mmiss=1 if WN156>9999900 & WN156<19999001; // missing variable code;

replace exactvalue=WN156;
replace lowervalue=WN157;
replace uppervalue=WN158;

imputethis;
replace WN156=exactvalue;


/*
tab WN195 WN196;
sum WN194;
gen guess = 0;
replace guess = 1 if WN195 == 0 & WN196 > 100000;
gen imp = 0;
replace imp = 1 if WN194 > 99990;
replace WN194=0 if (WN194==.|WN194>99900); 
egen mymin=min(WN196/5) if (WN196~=0 & WN196~=.);
egen mymax=max(WN195) if WN195~=.;
replace WN195=mymin if WN195==0; drop mymin;
replace WN196=mymax if WN196>100000 & WN196~=.; drop mymax;
replace WN194=sqrt(WN195*WN196) if (WN195~=. & WN196~=.);
replace WN194 = 3300 if guess == 1;
sort imp;
by imp: sum WN194 WN195 WN196;
drop guess imp;
*/



********************** impute WN194 using brackets ***********;

replace WN196=99000 if WN196>99000 & WN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace WN194=WN194*10 if (WN194>99000 & WN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace WN195=0 if WN195==. & WN194==999998;      // fix annoying quirk in data;
replace WN196=99000 if WN196==. & WN194==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WN194>-100 & WN194<999901; // donor group;
replace mmiss=1 if WN194>999900 & WN194<19999001; // missing variable code;

replace exactvalue=WN194;
replace lowervalue=WN195;
replace uppervalue=WN196;

imputethis;
replace WN194=exactvalue;



/*


tab WN246 WN247;
sum WN239;
gen guess = 0;
replace guess = 1 if WN246 == 0 & WN247 > 100000;
gen imp = 0;
replace imp = 1 if WN239 > 99990;
replace WN239=0 if (WN239==.|WN239>99900); 
egen mymin=min(WN247/5) if (WN247~=0 & WN247~=.);
egen mymax=max(WN246) if WN246~=.;
replace WN246=mymin if WN246==0; drop mymin;
replace WN247=mymax if WN247>100000 & WN247~=.; drop mymax;
replace WN239=sqrt(WN246*WN247) if (WN246~=. & WN247~=.);
replace WN239 = 930 if guess == 1;
sort imp;
by imp: sum WN239 WN246 WN247;
drop imp guess;
*/




********************** impute WN239 using brackets ***********;
replace WN247=99000 if WN247>999000 & WN247<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace WN246=0 if WN246==. & WN239==9999998;      // fix annoying quirk in data;
replace WN247=999000 if WN247==. & WN239==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WN239>-100 & WN239<9999991; // donor group;
replace mmiss=1 if WN239>9999990 & WN239<19999001; // missing variable code;

replace exactvalue=WN239;
replace lowervalue=WN246;
replace uppervalue=WN247;

imputethis;
replace WN239=exactvalue;

/*
tab WN334 WN335;
sum WN333;
gen guess = 0;
replace guess = 1 if WN334 == 0 & WN335 > 100000;
gen imp = 0;
replace imp = 1 if WN333 > 99990;
replace WN333=0 if (WN333==.|WN333>99900); 
egen mymin=min(WN335/5) if (WN335~=0 & WN335~=.);
egen mymax=max(WN334) if WN334~=.;
replace WN334=mymin if WN334==0; drop mymin;
replace WN335=mymax if WN335>100000 & WN335~=.; drop mymax;
replace WN333=sqrt(WN334*WN335) if (WN334~=. & WN335~=.);
* There was actually no need for the "Guess" or mymax on this one;
sum WN333 WN334 WN335;
sum WN333 if WN335~=.;
sum WN333 if WN335==. & WN333~=0;
drop guess imp;
*/


********************** impute WN333 using brackets ***********;
replace WN335=99000 if WN335>99000 & WN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace WN333=WN333*10 if (WN333>99900 & WN333<199001); * this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if WN333>-100 & WN333<999001; // donor group;
replace mmiss=1 if WN333>999000 & WN333<1999901; // missing variable code;

replace exactvalue=WN333;
replace lowervalue=WN334;
replace uppervalue=WN335;

imputethis;
replace WN333=exactvalue;


/*
tab WN339 WN340;
sum WN338;
gen guess = 0;
replace guess = 1 if WN339 == 0 & WN340 > 100000;
gen imp = 0;
replace imp = 1 if WN338 > 999900;
replace WN338=0 if (WN338==.|WN338>999000);
egen mymin=min(WN340/5) if (WN340~=0 & WN340~=.);
egen mymax=max(WN339) if WN339~=.;
replace WN339=mymin if WN339==0; drop mymin;
replace WN340=mymax if WN340>100000 & WN340~=.; drop mymax;
replace WN338=sqrt(WN339*WN340) if (WN339~=. & WN340~=.);
replace WN338 = 5300 if guess == 1;
sort imp;
by imp: sum WN338 WN339 WN340;
sum WN338 if WN340~=.;
sum WN338 if WN340==. & WN338~=0;
drop guess imp;
*/


********************** impute WN268 using brackets ***********;
replace WN270=99000 if WN270>990000 & WN270<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace VN338=VN338*10 if (VN338>999000 & VN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace WN269=0 if WN269==. & WN268==999998;      // fix annoying quirk in data;
replace WN270=99000 if WN270==. & WN268==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WN268>-100 & WN268<999001; // donor group;
replace mmiss=1 if WN268>999000 & WN268<1999001; // missing variable code;

replace exactvalue=WN268;
replace lowervalue=WN269;
replace uppervalue=WN270;

imputethis;
replace WN268=exactvalue;

********************** impute WN139 using brackets ***********;
replace WN141=900000 if WN141>9000000 & WN141<99999999999;

replace WN140=0 if WN140==. & WN139==9999998;      // fix annoying quirk in data;
replace WN141=900000 if WN141==. & WN139==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WN139>-100 & WN139<900001; // donor group;
replace mmiss=1 if WN139>900000 & WN139<19999001; // missing variable code;

replace exactvalue=WN139;
replace lowervalue=WN140;
replace uppervalue=WN141;

imputethis;
replace WN139=exactvalue;



gen doop10=WN106+WN119+WN328+WN156+WN194+WN239+WN333+WN268+WN139;

replace doop10=doop10/`divide';


/*
tab WN181 WN182;
sum WN180;
gen guess = 0;
replace guess = 1 if WN181 == 0 & WN182 > 100000;
gen imp = 0;
replace imp = 1 if WN180 > 9990;
replace WN180=0 if (WN180==.|WN180>9990);
egen mymin=min(WN182) if (WN182~=0 & WN182~=.);
egen mymax=max(WN181) if WN181~=.;
replace WN181=mymin if WN181==0; drop mymin;
replace WN182=mymax if WN182>100000 & WN182~=.; drop mymax;
replace WN180=sqrt(WN181*WN182) if (WN181~=. & WN182~=.);
replace WN180 = 230 if guess == 1;
sort imp;
by imp: sum WN180 WN181 WN182;
sum WN180 if WN182~=.;
sum WN180 if WN182==. & WN180~=0;
*/

********************** impute WN180 using brackets ***********;
replace WN182=9000 if WN182>9000 & WN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace WN181=0 if WN181==. & WN180==99998;      //fix annoying quirk in data;
replace WN182=9000 if WN182==. & WN180==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WN180>-100 & WN180<99990; // donor group;
replace mmiss=1 if WN180>99990 & WN180<199991; // missing variable code;

replace exactvalue=WN180;
replace lowervalue=WN181;
replace uppervalue=WN182;

imputethis;

*sum exactvalue WN180 if WN181==.;
*sum exactvalue WN180 if WN181~=.;
*sum exactvalue WN180 if WN181==. & exactvalue~=0;
*exit;

replace WN180=exactvalue;

gen ddrugc10=WN180*12; // yearly out-of-pocket drug costs;
gen dhospc10=WN106/`divide';
gen dnursc10=WN119/`divide';
gen ddocc10= WN156/`divide';
gen dhhsc10=WN194/`divide';
gen dothels10=(WN239+WN333+WN268+WN328+WN139)/`divide';
 
sum WN106 WN119 WN328 WN156 WN194 WN239 WN332 WN268 doop10 ddrugc10 dhospc10 dnursc10 ddocc10 dhhsc10 dothels10;


keep HHID PN doop10 ddrugc10 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave10d'x10N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid10=9;
replace dmedicaid10=1 if WN005==1;
replace dmedicaid10=0 if WN005==5;

sum WN014 WN040_1 WN040_2 WN040_3 WN080 WN081;

replace WN014=0 if (WN014==.|WN014>990);
replace WN040_1=0 if (WN040_1==.|WN040_1>9000);                                 //one value at 2000 one value above 2000
replace WN040_2=0 if (WN040_2==.|WN040_2>990);
replace WN040_3=0 if (WN040_3==.|WN040_3>990);

replace WN080=0 if (WN080==.|WN080>990);
replace WN081=0 if (WN081==.|WN081>990);

gen medicare=WN014;
gen private=WN040_1+WN040_2+WN040_3;
gen privateannual=private*12;


gen LTC=(WN080+WN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem10=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc10=doop10+ddrugc10+diprem10;
sum ddrugc10 dmedc10 diprem10;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave10d'x10N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=WN223;
*replace topcost=(WN222*3) if WN223>(3*WN222);


*gen dtcx=sqrt(WN222*WN223);
*gen dtc10=(WN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc10=dtcx;


*replace dtc10=dtc10/`divide';

*sum dtc10;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop WN*;

compress;
sort HHID PN; 
save `saved'exitmedcost, replace;
summ;
*drop _all;






************************Wave XI ************************;

clear; 
use `wave11d'x12N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*XN106=AMT PAID O-O-P HOSPITAL COSTS;
*XN119=AMT PAID O-O-P NURSING HOME;
*XN328=AMT O-O-P COSTS - HOSPICE;
*XN156=AMT PAY O-O-P FOR DOC VISITS;
*XN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*XN194=AMT PAY O-O-P HOME HEALTH SVC;
*XN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*XN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*XN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES - not in wave 11;




********************** impute XN106 using brackets ***********;

replace XN108=99000 if XN108>9999000 & XN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if XN106>-100 & XN106<99901; // donor group check - 250k value?;
replace mmiss=1 if XN106>99901 & XN106<19990001; // missing variable code CHECK v WAVE 10;

gen exactvalue=XN106;
gen lowervalue=XN107;
gen uppervalue=XN108;

imputethis;
replace XN106=exactvalue;



********************** impute XN119 using brackets ***********;
replace XN121=999000 if XN121>999000 & XN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XN120=0 if XN120==. & XN119==9999998;      // fix annoying quirk in data;
replace XN121=999000 if XN121==. & XN119==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XN119>-100 & XN119<9990001; // donor group;
replace mmiss=1 if XN119>9990000 & XN119<19999001; // missing variable code;

replace exactvalue=XN119;
replace lowervalue=XN120;
replace uppervalue=XN121;

imputethis;
replace XN119=exactvalue;


********************** impute XN328 using brackets ***********;
replace XN330=99000 if XN330>999000 & XN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if XN328>-100 & XN328<9999991; // donor group;
replace mmiss=1 if XN328>9999990 & XN328<19990001; // missing variable code;

replace exactvalue=XN328;
replace lowervalue=XN329;
replace uppervalue=XN330;

imputethis;
replace XN328=exactvalue;





********************** impute XN156 using brackets ***********;

replace XN158=99000 if XN158>999000 & XN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if XN156>-100 & XN156<9999901; // donor group;
replace mmiss=1 if XN156>9999900 & XN156<19999001; // missing variable code;

replace exactvalue=XN156;
replace lowervalue=XN157;
replace uppervalue=XN158;

imputethis;
replace XN156=exactvalue;






********************** impute XN194 using brackets ***********;

replace XN196=99000 if XN196>99000 & XN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace XN194=XN194*10 if (XN194>99000 & XN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace XN195=0 if XN195==. & XN194==999998;      // fix annoying quirk in data;
replace XN196=99000 if XN196==. & XN194==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XN194>-100 & XN194<999901; // donor group;
replace mmiss=1 if XN194>999900 & XN194<19999001; // missing variable code;

replace exactvalue=XN194;
replace lowervalue=XN195;
replace uppervalue=XN196;

imputethis;
replace XN194=exactvalue;







********************** impute XN239 using brackets ***********;
replace XN247=99000 if XN247>999000 & XN247<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XN246=0 if XN246==. & XN239==9999998;      // fix annoying quirk in data;
replace XN247=999000 if XN247==. & XN239==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XN239>-100 & XN239<9999991; // donor group;
replace mmiss=1 if XN239>9999990 & XN239<19999001; // missing variable code;

replace exactvalue=XN239;
replace lowervalue=XN246;
replace uppervalue=XN247;

imputethis;
replace XN239=exactvalue;


********************** impute XN333 using brackets ***********;
replace XN335=99000 if XN335>99000 & XN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace XN333=XN333*10 if (XN333>99900 & XN333<199001); * this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if XN333>-100 & XN333<999001; // donor group;
replace mmiss=1 if XN333>999000 & XN333<1999901; // missing variable code;

replace exactvalue=XN333;
replace lowervalue=XN334;
replace uppervalue=XN335;

imputethis;
replace XN333=exactvalue;



********************** impute XN268 using brackets ***********;
replace XN270=99000 if XN270>990000 & XN270<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace VN338=VN338*10 if (VN338>999000 & VN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace XN269=0 if XN269==. & XN268==999998;      // fix annoying quirk in data;
replace XN270=99000 if XN270==. & XN268==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XN268>-100 & XN268<999001; // donor group;
replace mmiss=1 if XN268>999000 & XN268<1999001; // missing variable code;

replace exactvalue=XN268;
replace lowervalue=XN269;
replace uppervalue=XN270;

imputethis;
replace XN268=exactvalue;

********************** impute XN139 using brackets ***********;
replace XN141=900000 if XN141>9000000 & XN141<99999999999;

replace XN140=0 if XN140==. & XN139==9999998;      // fix annoying quirk in data;
replace XN141=900000 if XN141==. & XN139==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XN139>-100 & XN139<900001; // donor group;
replace mmiss=1 if XN139>900000 & XN139<19999001; // missing variable code;

replace exactvalue=XN139;
replace lowervalue=XN140;
replace uppervalue=XN141;

imputethis;
replace XN139=exactvalue;



gen doop11=XN106+XN119+XN328+XN156+XN194+XN239+XN333+XN268+XN139;

replace doop11=doop11/`divide';


********************** impute XN180 using brackets ***********;
replace XN182=9000 if XN182>9000 & XN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XN181=0 if XN181==. & XN180==99998;      //fix annoying quirk in data;
replace XN182=9000 if XN182==. & XN180==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XN180>-100 & XN180<99990; // donor group;
replace mmiss=1 if XN180>99990 & XN180<199991; // missing variable code;

replace exactvalue=XN180;
replace lowervalue=XN181;
replace uppervalue=XN182;

imputethis;

*sum exactvalue XN180 if XN181==.;
*sum exactvalue XN180 if XN181~=.;
*sum exactvalue XN180 if XN181==. & exactvalue~=0;
*exit;

replace XN180=exactvalue;

gen ddrugc11=XN180*12; // yearly out-of-pocket drug costs;
gen dhospc11=XN106/`divide';
gen dnursc11=XN119/`divide';
gen ddocc11= XN156/`divide';
gen dhhsc11=XN194/`divide';
gen dothels11=(XN239+XN333+XN268+XN328+XN139)/`divide';
 
sum XN106 XN119 XN328 XN156 XN194 XN239 XN332 XN268 doop11 ddrugc11 dhospc11 dnursc11 ddocc11 dhhsc11 dothels11;


keep HHID PN doop11 ddrugc11 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave11d'x12N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid11=9;
replace dmedicaid11=1 if XN005==1;
replace dmedicaid11=0 if XN005==5;

sum XN014 XN040_1 XN040_2 XN040_3 XN080 XN081;

replace XN014=0 if (XN014==.|XN014>990);

replace XN040_1=0 if (XN040_1==.|XN040_1>9000);                                 //one value at 2000 one value greater than 2000
replace XN040_2=0 if (XN040_2==.|XN040_2>990);
replace XN040_3=0 if (XN040_3==.|XN040_3>990);

replace XN080=0 if (XN080==.|XN080>990);
replace XN081=0 if (XN081==.|XN081>990);

gen medicare=XN014;
gen private=XN040_1+XN040_2+XN040_3;
gen privateannual=private*12;


gen LTC=(XN080+XN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem11=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc11=doop11+ddrugc11+diprem11;
sum ddrugc11 dmedc11 diprem11;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave11d'x12N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=XN223;
*replace topcost=(XN222*3) if XN223>(3*XN222);


*gen dtcx=sqrt(XN222*XN223);
*gen dtc10=(XN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc10=dtcx;


*replace dtc10=dtc10/`divide';

*sum dtc10;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop XN*;

compress;
sort HHID PN; 
save `saved'exitmedcost, replace;
summ;


************************Wave XII ************************;

clear; 
use `wave12d'x14N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*YN106=AMT PAID O-O-P HOSPITAL COSTS;
*YN119=AMT PAID O-O-P NURSING HOME;
*YN328=AMT O-O-P COSTS - HOSPICE;
*YN156=AMT PAY O-O-P FOR DOC VISITS;
*YN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*YN194=AMT PAY O-O-P HOME HEALTH SVC;
*YN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*YN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*YN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES - not in wave 12;




********************** impute YN106 using brackets ***********;

replace YN108=99000 if YN108>9999000 & YN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if YN106>-100 & YN106<99901; // donor group check - 250k value?;
replace mmiss=1 if YN106>99900 & YN106<199990001; // missing variable code CHECK v WAVE 10;

gen exactvalue=YN106;
gen lowervalue=YN107;
gen uppervalue=YN108;

imputethis;
replace YN106=exactvalue;



********************** impute YN119 using brackets ***********;
replace YN121=999000 if YN121>999000 & YN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace YN120=0 if YN120==. & YN119==999998;      // fix annoying quirk in data;
replace YN121=999000 if YN121==. & YN119==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YN119>-100 & YN119<999001; // donor group;
replace mmiss=1 if YN119>999000 & YN119<199999001; // missing variable code;

replace exactvalue=YN119;
replace lowervalue=YN120;
replace uppervalue=YN121;

imputethis;
replace YN119=exactvalue;


********************** impute YN328 using brackets ***********;
replace YN330=99000 if YN330>999000 & YN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if YN328>-100 & YN328<99091; // donor group;
replace mmiss=1 if YN328>99090 & YN328<19990001; // missing variable code;

replace exactvalue=YN328;
replace lowervalue=YN329;
replace uppervalue=YN330;

imputethis;
replace YN328=exactvalue;





********************** impute YN156 using brackets ***********;

replace YN158=99000 if YN158>999000 & YN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if YN156>-100 & YN156<999901; // donor group;
replace mmiss=1 if YN156>999900 & YN156<199999001; // missing variable code;

replace exactvalue=YN156;
replace lowervalue=YN157;
replace uppervalue=YN158;

imputethis;
replace YN156=exactvalue;






********************** impute YN194 using brackets ***********;

replace YN196=99000 if YN196>99000 & YN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace YN194=YN194*10 if (YN194>99000 & YN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace YN195=0 if YN195==. & YN194==999998;      // fix annoying quirk in data;
replace YN196=99000 if YN196==. & YN194==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YN194>-100 & YN194<999901; // donor group;
replace mmiss=1 if YN194>999900 & YN194<19999001; // missing variable code;

replace exactvalue=YN194;
replace lowervalue=YN195;
replace uppervalue=YN196;

imputethis;
replace YN194=exactvalue;







********************** impute YN239 using brackets ***********;
replace YN247=99000 if YN247>999000 & YN247<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace YN246=0 if YN246==. & YN239==99998;      // fix annoying quirk in data;
replace YN247=999000 if YN247==. & YN239==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YN239>-100 & YN239<99991; // donor group;
replace mmiss=1 if YN239>99990 & YN239<199999001; // missing variable code;

replace exactvalue=YN239;
replace lowervalue=YN246;
replace uppervalue=YN247;

imputethis;
replace YN239=exactvalue;


********************** impute YN333 using brackets ***********;
replace YN335=99000 if YN335>99000 & YN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace YN333=YN333*10 if (YN333>99900 & YN333<1099001); * this makes missing value code bigger than max range value -- need this for imputations;

gen mmiss=.;
replace mmiss=0 if YN333>-100 & YN333<999001; // donor group;
replace mmiss=1 if YN333>999000 & YN333<1999901; // missing variable code;

replace exactvalue=YN333;
replace lowervalue=YN334;
replace uppervalue=YN335;

imputethis;
replace YN333=exactvalue;



********************** impute YN268 using brackets ***********;
replace YN270=99000 if YN270>990000 & YN270<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace VN338=VN338*10 if (VN338>999000 & VN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace YN269=0 if YN269==. & YN268==99998;      // fix annoying quirk in data;
replace YN270=99000 if YN270==. & YN268==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YN268>-100 & YN268<99901; // donor group;
replace mmiss=1 if YN268>99900 & YN268<19999001; // missing variable code;

replace exactvalue=YN268;
replace lowervalue=YN269;
replace uppervalue=YN270;

imputethis;
replace YN268=exactvalue;

********************** impute YN139 using brackets ***********;
replace YN141=900000 if YN141>9000000 & YN141<99999999999;

replace YN140=0 if YN140==. & YN139==9998;      // fix annoying quirk in data;
replace YN141=900000 if YN141==. & YN139==9998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YN139>-100 & YN139<9901; // donor group;
replace mmiss=1 if YN139>9900 & YN139<19999001; // missing variable code;

replace exactvalue=YN139;
replace lowervalue=YN140;
replace uppervalue=YN141;

imputethis;
replace YN139=exactvalue;



gen doop12=YN106+YN119+YN328+YN156+YN194+YN239+YN333+YN268+YN139;

replace doop12=doop12/`divide';


********************** impute YN180 using brackets ***********;
replace YN182=9000 if YN182>9000 & YN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace YN181=0 if YN181==. & YN180==9998;      //fix annoying quirk in data;
replace YN182=9000 if YN182==. & YN180==9998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YN180>-100 & YN180<9991; // donor group;
replace mmiss=1 if YN180>9990 & YN180<1999991; // missing variable code;

replace exactvalue=YN180;
replace lowervalue=YN181;
replace uppervalue=YN182;

imputethis;

*sum exactvalue YN180 if YN181==.;
*sum exactvalue YN180 if YN181~=.;
*sum exactvalue YN180 if YN181==. & exactvalue~=0;
*exit;

replace YN180=exactvalue;

gen ddrugc12=YN180*12; // yearly out-of-pocket drug costs;
gen dhospc12=YN106/`divide';
gen dnursc12=YN119/`divide';
gen ddocc12= YN156/`divide';
gen dhhsc12=YN194/`divide';
gen dothels12=(YN239+YN333+YN268+YN328+YN139)/`divide';
sum YN106 YN119 YN328 YN156 YN194 YN239 YN332 YN268 doop12 ddrugc12 dhospc12 dnursc12 ddocc12 dhhsc12 dothels12;


keep HHID PN doop12 ddrugc12 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave12d'x14N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid12=9;
replace dmedicaid12=1 if YN005==1;
replace dmedicaid12=0 if YN005==5;

sum YN014 YN040_1 YN040_2 YN040_3 YN080 YN081;

replace YN014=0 if (YN014==.|YN014>990);

replace YN040_1=0 if (YN040_1==.|YN040_1>9000);
replace YN040_2=0 if (YN040_2==.|YN040_2>990);
replace YN040_3=0 if (YN040_3==.|YN040_3>990);

replace YN080=0 if (YN080==.|YN080>990);
replace YN081=0 if (YN081==.|YN081>990);                                        

gen medicare=YN014;
gen private=YN040_1+YN040_2+YN040_3;
gen privateannual=private*12;


gen LTC=(YN080+YN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem12=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc12=doop12+ddrugc12+diprem12;
sum ddrugc12 dmedc12 diprem12;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave12d'x14N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=XN223;
*replace topcost=(XN222*3) if XN223>(3*XN222);


*gen dtcx=sqrt(XN222*XN223);
*gen dtc10=(XN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc10=dtcx;


*replace dtc10=dtc10/`divide';

*sum dtc10;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop YN*;

compress;
sort HHID PN; 
save `saved'exitmedcost, replace;
summ;


************************WAVE 13 ************************;

clear; 
use `wave13d'x16N_R;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*ZN106=AMT PAID O-O-P HOSPITAL COSTS;
*ZN119=AMT PAID O-O-P NURSING HOME;
*ZN328=AMT O-O-P COSTS - HOSPICE;
*ZN156=AMT PAY O-O-P FOR DOC VISITS;
*ZN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*ZN194=AMT PAY O-O-P HOME HEALTH SVC;
*ZN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*ZN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*ZN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES - not in wave 13;




********************** impute ZN106 using brackets ***********;

replace ZN108=99000 if ZN108>9999000 & ZN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

*replace ZN107=0 if ZN107==. & (ZN106==999998|ZN106==999999);
*replace ZN108=99000 if ZN108==. & (ZN106==999998|ZN106==999999);//here !!----------;

gen mmiss=.;
replace mmiss=0 if ZN106>-100 & ZN106<999991; // donor group check - 250k value?;
replace mmiss=1 if ZN106>999990 & ZN106<19999990001; // missing variable code CHECK v WAVE 10;

gen exactvalue=ZN106;
gen lowervalue=ZN107;
gen uppervalue=ZN108;

imputethis;
replace ZN106=exactvalue;



********************** impute ZN119 using brackets ***********;
replace ZN121=999000 if ZN121>999000 & ZN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ZN120=0 if ZN120==. & ZN119==999998;      // fix annoying quirk in data;
replace ZN121=999000 if ZN121==. & ZN119==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZN119>-100 & ZN119<999001; // donor group;
replace mmiss=1 if ZN119>999000 & ZN119<19999999001; // missing variable code;

replace exactvalue=ZN119;
replace lowervalue=ZN120;
replace uppervalue=ZN121;

imputethis;
replace ZN119=exactvalue;


********************** impute ZN328 using brackets ***********;
replace ZN330=99000 if ZN330>99000 & ZN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

*replace ZN329=0 if ZN329==. & (ZN328==99998|ZN328==99999);
*replace ZN330=99000 if ZN330==. & (ZN328==99998|ZN328==99999);//here !!----------;

gen mmiss=.;
replace mmiss=0 if ZN328>-100 & ZN328<99991; // donor group;
replace mmiss=1 if ZN328>99990 & ZN328<1999990001; // missing variable code;

replace exactvalue=ZN328;
replace lowervalue=ZN329;
replace uppervalue=ZN330;

imputethis;
replace ZN328=exactvalue;





********************** impute ZN156 using brackets ***********;

replace ZN158=99000 if ZN158>999000 & ZN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

*replace ZN157=0 if ZN157==. & ZN156==99998;
*replace ZN158=99000 if ZN158==. & ZN156==99998;//here !!----------;

gen mmiss=.;
replace mmiss=0 if ZN156>-100 & ZN156<99990; // donor group;
replace mmiss=1 if ZN156>99990 & ZN156<1999999001; // missing variable code;

replace exactvalue=ZN156;
replace lowervalue=ZN157;
replace uppervalue=ZN158;

imputethis;
replace ZN156=exactvalue;






********************** impute ZN194 using brackets ***********;

replace ZN196=99000 if ZN196>99000 & ZN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace ZN194=YN194*10 if (ZN194>99000 & ZN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace ZN195=0 if ZN195==. & ( ZN194==999998 | ZN194==999999 );      // fix annoying quirk in data;
replace ZN196=99000 if ZN196==. & ( ZN194==999998 | ZN194==999999 );  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZN194>-100 & ZN194<999901; // donor group;
replace mmiss=1 if ZN194>999901 & ZN194<199999001; // missing variable code;

replace exactvalue=ZN194;
replace lowervalue=ZN195;
replace uppervalue=ZN196;

imputethis;
replace ZN194=exactvalue;







********************** impute ZN239 using brackets ***********;
replace ZN247=99000 if ZN247>999000 & ZN247<999999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ZN246=0 if ZN246==. & ( ZN239==99998 | ZN239==99999 );      // fix annoying quirk in data;
replace ZN247=999000 if ZN247==. & ( ZN239==99998 | ZN239==99999 );  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZN239>-100 & ZN239<99991; // donor group;
replace mmiss=1 if ZN239>99990 & ZN239<199999001; // missing variable code;

replace exactvalue=ZN239;
replace lowervalue=ZN246;
replace uppervalue=ZN247;

imputethis;
replace ZN239=exactvalue;


********************** impute ZN333 using brackets ***********;
replace ZN335=99000 if ZN335>99000 & ZN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace ZN333=ZN333*10 if (ZN333>99900 & ZN333<1099001); * this makes missing value code bigger than max range value -- need this for imputations;


*replace ZN334=0 if ZN334==. & ZN333==999998;   //here !!----------;
*replace ZN335=99000 if ZN335==. & ZN333==999998;

gen mmiss=.;
replace mmiss=0 if ZN333>-100 & ZN333<999001; // donor group;
replace mmiss=1 if ZN333>999000 & ZN333<199999901; // missing variable code;

replace exactvalue=ZN333;
replace lowervalue=ZN334;
replace uppervalue=ZN335;

imputethis;
replace ZN333=exactvalue;



********************** impute ZN268 using brackets ***********;
replace ZN270=99000 if ZN270>990000 & ZN270<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace VN338=VN338*10 if (VN338>999000 & VN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace ZN269=0 if ZN269==. & ZN268==99998;      // fix annoying quirk in data;
replace ZN270=99000 if ZN270==. & ZN268==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZN268>-100 & ZN268<99901; // donor group;
replace mmiss=1 if ZN268>99900 & ZN268<199999001; // missing variable code;

replace exactvalue=ZN268;
replace lowervalue=ZN269;
replace uppervalue=ZN270;

imputethis;
replace ZN268=exactvalue;

********************** impute ZN139 using brackets ***********;
replace ZN141=900000 if ZN141>9000000 & ZN141<99999999999;

replace ZN140=0 if ZN140==. & ZN139==99998;      // fix annoying quirk in data;
replace ZN141=900000 if ZN141==. & ZN139==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZN139>-100 & ZN139<99901; // donor group;
replace mmiss=1 if ZN139>99900 & ZN139<19999001; // missing variable code;

replace exactvalue=ZN139;
replace lowervalue=ZN140;
replace uppervalue=ZN141;

imputethis;
replace ZN139=exactvalue;



gen doop13=ZN106+ZN119+ZN328+ZN156+ZN194+ZN239+ZN333+ZN268+ZN139;

replace doop13=doop13/`divide';


********************** impute YN180 using brackets ***********;
replace ZN182=9000 if ZN182>9000 & ZN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ZN181=0 if ZN181==. & (ZN180==9998|ZN180==9999);      //fix annoying quirk in data;
replace ZN182=9000 if ZN182==. & (ZN180==9998|ZN180==9999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZN180>-100 & ZN180<9991; // donor group;
replace mmiss=1 if ZN180>9990 & ZN180<1999991; // missing variable code;

replace exactvalue=ZN180;
replace lowervalue=ZN181;
replace uppervalue=ZN182;

imputethis;

*sum exactvalue ZN180 if ZN181==.;
*sum exactvalue ZN180 if ZN181~=.;
*sum exactvalue ZN180 if ZN181==. & exactvalue~=0;
*exit;

replace ZN180=exactvalue;

gen ddrugc13=ZN180*12; // yearly out-of-pocket drug costs;
gen dhospc13=ZN106/`divide';
gen dnursc13=ZN119/`divide';
gen ddocc13= ZN156/`divide';
gen dhhsc13=ZN194/`divide';
gen dothels13=(ZN239+ZN333+ZN268+ZN328+ZN139)/`divide';
sum ZN106 ZN119 ZN328 ZN156 ZN194 ZN239 ZN332 ZN268 doop13 ddrugc13 dhospc13 dnursc13 ddocc13 dhhsc13 dothels13;


keep HHID PN doop13 ddrugc13 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave13d'x16N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid13=9;
replace dmedicaid13=1 if ZN005==1;
replace dmedicaid13=0 if ZN005==5;

sum ZN014 ZN040_1 ZN040_2 ZN040_3 ZN080 ZN081;

replace ZN014=0 if (ZN014==.|ZN014>990);

replace ZN040_1=0 if (ZN040_1==.|ZN040_1>9000);
replace ZN040_2=0 if (ZN040_2==.|ZN040_2>990);
replace ZN040_3=0 if (ZN040_3==.|ZN040_3>990);

replace ZN080=0 if (ZN080==.|ZN080>990);
replace ZN081=0 if (ZN081==.|ZN081>990);                                        

gen medicare=ZN014;
gen private=ZN040_1+ZN040_2+ZN040_3;
gen privateannual=private*12;


gen LTC=(ZN080+ZN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem13=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc13=doop13+ddrugc13+diprem13;
sum ddrugc13 dmedc13 diprem13;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave13d'x16N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=ZN223;
*replace topcost=(ZN222*3) if ZN223>(3*ZN222);


*gen dtcx=sqrt(ZN222*ZN223);
*gen dtc13=(ZN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc13=dtcx;


*replace dtc13=dtc13/`divide';

*sum dtc13;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop ZN*;

compress;
sort HHID PN; 
sleep 1000;
save `saved'exitmedcost, replace;
summ;
***************************************************** END WAVE 13;

************************WAVE 14 ************************;

clear; 
use `wave14d'x18N_R;
*rename hhid HHID;
*rename pn PN;

* convert into one-year variable;
*Where doop=oop hospital costs+ oop nursing home+ oop doctor visits...;
*...+oop home health svc+oop other health service;
*hospital and nursing home costs were two separate variables in wave 6;
* check topcoding on both of these variables--especially SN338;

*XQN106=AMT PAID O-O-P HOSPITAL COSTS;
*XQN119=AMT PAID O-O-P NURSING HOME;
*XQN328=AMT O-O-P COSTS - HOSPICE;
*XQN156=AMT PAY O-O-P FOR DOC VISITS;
*XQN180=AMT PAY O-O-P RX DRUGS PER MONTH;
*XQN194=AMT PAY O-O-P HOME HEALTH SVC;
*XQN239=AMT PAY O-O-P OTHER HEALTH SERVICE;
*XQN333=AMT OTHER O-O-P MEDICAL EXPENSES;
*XQN338=AMT HEALTH RELATED NON-MEDICAL EXPENSES - not in wave 14;




********************** impute XQN106 using brackets ***********;

replace XQN108=99000 if XQN108>9999000 & XQN108<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*							   99999996.  Greater than Maximum Breakpoint;
*replace XQN107=0 if XQN107==. & (XQN106==999998|XQN106==999999);
*replace XQN108=99000 if XQN108==. & (XQN106==999998|XQN106==999999);//here !!----------;


gen mmiss=.;
replace mmiss=0 if XQN106>-100 & XQN106<99991;  
replace mmiss=1 if XQN106>99990 & XQN106<19999990001;  
* Chris: I checked codebook for above and amended it ;

gen exactvalue=XQN106;
gen lowervalue=XQN107;
gen uppervalue=XQN108;

imputethis;
replace XQN106=exactvalue;



********************** impute XQN119 using brackets ***********;
replace XQN121=999000 if XQN121>999000 & XQN121<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XQN120=0 if XQN120==. & XQN119==999998;      // fix annoying quirk in data;
replace XQN121=999000 if XQN121==. & XQN119==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQN119>-100 & XQN119<999001; // donor group;
replace mmiss=1 if XQN119>999000 & XQN119<19999999001; // missing variable code;
* Chris: I checked codebook for above ;

replace exactvalue=XQN119;
replace lowervalue=XQN120;
replace uppervalue=XQN121;

imputethis;
replace XQN119=exactvalue;


********************** impute XQN328 using brackets ***********;
replace XQN330=99000 if XQN330>99000 & XQN330<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

*replace XQN329=0 if XQN329==. & (XQN328==99998|XQN328==99999);
*replace XQN330=99000 if XQN330==. & (XQN328==99998|XQN328==99999);//here !!----------;

gen mmiss=.;
replace mmiss=0 if XQN328>-100 & XQN328<99991; // donor group;
replace mmiss=1 if XQN328>99990 & XQN328<1999990001; // missing variable code;
* Chris: I checked codebook for above ;

replace exactvalue=XQN328;
replace lowervalue=XQN329;
replace uppervalue=XQN330;

imputethis;
replace XQN328=exactvalue;





********************** impute XQN156 using brackets ***********;

replace XQN158=99000 if XQN158>999000 & XQN158<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

*replace XQN157=0 if XQN157==. & XQN156==99998;
*replace XQN158=99000 if XQN158==. & XQN156==99998;//here !!----------;

gen mmiss=.;
replace mmiss=0 if XQN156>-100 & XQN156<99990; // donor group;
replace mmiss=1 if XQN156>99990 & XQN156<1999999001; // missing variable code;
* Chris: I checked codebook for above ;

replace exactvalue=XQN156;
replace lowervalue=XQN157;
replace uppervalue=XQN158;

imputethis;
replace XQN156=exactvalue;






********************** impute XQN194 using brackets ***********;

replace XQN196=99000 if XQN196>99000 & XQN196<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace XQN194=YN194*10 if (XQN194>99000 & XQN194<999001); * this makes missing value code bigger than max range value -- need this for imputations;

replace XQN195=0 if XQN195==. & ( XQN194==999998 | XQN194==999999 );      // fix annoying quirk in data;
replace XQN196=99000 if XQN196==. & ( XQN194==999998 | XQN194==999999 );  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQN194>-100 & XQN194<999901; // donor group;
replace mmiss=1 if XQN194>999901 & XQN194<199999001; // missing variable code;
* 						  999998 ;
* Chris: I checked codebook for above ;

replace exactvalue=XQN194;
replace lowervalue=XQN195;
replace uppervalue=XQN196;

imputethis;
replace XQN194=exactvalue;







********************** impute XQN239 using brackets ***********;
replace XQN247=99000 if XQN247>999000 & XQN247<999999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XQN246=0 if XQN246==. & ( XQN239==99998 | XQN239==99999 );      // fix annoying quirk in data;
replace XQN247=999000 if XQN247==. & ( XQN239==99998 | XQN239==99999 );  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQN239>-100 & XQN239<99991; // donor group;
replace mmiss=1 if XQN239>99990 & XQN239<199999001; // missing variable code;
* Chris: I checked codebook for above ;

replace exactvalue=XQN239;
replace lowervalue=XQN246;
replace uppervalue=XQN247;

imputethis;
replace XQN239=exactvalue;


********************** impute XQN333 using brackets ***********;
replace XQN335=99000 if XQN335>99000 & XQN335<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
*replace XQN333=XQN333*10 if (XQN333>99900 & XQN333<1099001); * this makes missing value code bigger than max range value -- need this for imputations;


*replace XQN334=0 if XQN334==. & XQN333==999998;   //here !!----------;
*replace XQN335=99000 if XQN335==. & XQN333==999998;

gen mmiss=.;
replace mmiss=0 if XQN333>-100 & XQN333<99001; // donor group;
replace mmiss=1 if XQN333>99000 & XQN333<199999901; // missing variable code;
* Chris: I checked codebook for above and amended it ;


replace exactvalue=XQN333;
replace lowervalue=XQN334;
replace uppervalue=XQN335;

imputethis;
replace XQN333=exactvalue;



********************** impute XQN268 using brackets ***********;
replace XQN270=99000 if XQN270>990000 & XQN270<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* replace VN338=VN338*10 if (VN338>999000 & VN338<1990001); * this makes missing value code bigger than max range value -- need this for imputations;

replace XQN269=0 if XQN269==. & XQN268==99998;      // fix annoying quirk in data;
replace XQN270=99000 if XQN270==. & XQN268==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQN268>-100 & XQN268<99901; // donor group;
replace mmiss=1 if XQN268>99900 & XQN268<199999001; // missing variable code;
* Chris: I checked codebook for above;

replace exactvalue=XQN268;
replace lowervalue=XQN269;
replace uppervalue=XQN270;

imputethis;
replace XQN268=exactvalue;

********************** impute XQN139 using brackets ***********;
replace XQN141=900000 if XQN141>9000000 & XQN141<99999999999;

replace XQN140=0 if XQN140==. & XQN139==99998;      // fix annoying quirk in data;
replace XQN141=900000 if XQN141==. & XQN139==99998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQN139>-100 & XQN139<9901; // donor group;
replace mmiss=1 if XQN139>9900 & XQN139<19999001; // missing variable code;
* Chris: I checked codebook for above and amended it ;

replace exactvalue=XQN139;
replace lowervalue=XQN140;
replace uppervalue=XQN141;

imputethis;
replace XQN139=exactvalue;



gen doop14=XQN106+XQN119+XQN328+XQN156+XQN194+XQN239+XQN333+XQN268+XQN139;

replace doop14=doop14/`divide';


********************** impute YN180 using brackets ***********;
replace XQN182=9000 if XQN182>9000 & XQN182<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XQN181=0 if XQN181==. & (XQN180==9998|XQN180==9999);      //fix annoying quirk in data;
replace XQN182=9000 if XQN182==. & (XQN180==9998|XQN180==9999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQN180>-100 & XQN180<9991; // donor group;
replace mmiss=1 if XQN180>9990 & XQN180<1999991; // missing variable code;
* Chris: I checked codebook for above;

replace exactvalue=XQN180;
replace lowervalue=XQN181;
replace uppervalue=XQN182;

imputethis;

*sum exactvalue XQN180 if XQN181==.;
*sum exactvalue XQN180 if XQN181~=.;
*sum exactvalue XQN180 if XQN181==. & exactvalue~=0;
*exit;

replace XQN180=exactvalue;

gen ddrugc14=XQN180*12; // yearly out-of-pocket drug costs;
gen dhospc14=XQN106/`divide';
gen dnursc14=XQN119/`divide';
gen ddocc14= XQN156/`divide';
gen dhhsc14=XQN194/`divide';
gen dothels14=(XQN239+XQN333+XQN268+XQN328+XQN149)/`divide';
sum XQN106 XQN119 XQN328 XQN156 XQN194 XQN239 XQN332 XQN268 doop14 ddrugc14 dhospc14 dnursc14 ddocc14 dhhsc14 dothels14;


keep HHID PN doop14 ddrugc14 dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 


sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 


keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 


sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
clear; 

****************************************************;
use `wave14d'x18N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen dmedicaid14=9;
replace dmedicaid14=1 if XQN005==1;
replace dmedicaid14=0 if XQN005==5;

sum XQN014 XQN040_1 XQN040_2 XQN040_3 XQN080 XQN081;

replace XQN014=0 if (XQN014==.|XQN014>990);

replace XQN040_1=0 if (XQN040_1==.|XQN040_1>9000);
replace XQN040_2=0 if (XQN040_2==.|XQN040_2>990);
replace XQN040_3=0 if (XQN040_3==.|XQN040_3>990);

replace XQN080=0 if (XQN080==.|XQN080>990);
replace XQN081=0 if (XQN081==.|XQN081>990);                                        

gen medicare=XQN014;
gen private=XQN040_1+XQN040_2+XQN040_3;
gen privateannual=private*12;


gen LTC=(XQN080+XQN081)/2; // long term care insurance;
replace LTC=LTC*12;


sum medicare privateannual LTC;

gen diprem14=medicare+privateannual+LTC;

*gen temp=real(HHID); 
*drop HHID; 
*rename temp HHID; 
*gen temp=real(PN); 
*drop PN; 
*rename temp PN; 
sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
sleep 1000; save `saved'exit, replace; 
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*; 
gen dmedc14=doop14+ddrugc14+diprem14;
sum ddrugc14 dmedc14 diprem14;
sort HHID PN;
keep HHID PN doop* ddrugc* dmed* diprem* dtc* dhospc* dnursc* ddocc* dhhsc* dothels*;  
sleep 1000; save `saved'exit, replace; 
clear; 

use `wave14d'x18N_R; // health insurance;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

*gen topcost=XQN223;
*replace topcost=(XQN222*3) if XQN223>(3*XQN222);


*gen dtcx=sqrt(XQN222*XQN223);
*gen dtc14=(XQN222+topcost)/2;  * this needs to be fixed--it also  needs to be divided by `divide';

*sum dtc*;
*replace dtc14=dtcx;


*replace dtc14=dtc14/`divide';

*sum dtc14;

sort HHID PN; 
merge HHID PN using `saved'exit; 
drop _merge; 
sort HHID PN; 
drop XQN*;

compress;
sort HHID PN; 
sleep 1000;
save `saved'exitmedcost, replace;
summ;
***************************************************** END WAVE 14;
log close;
* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(exitmedcost.xlsx) replace;
cd "$folder\hrs\merge\" ;
use exitmedcost.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(exitmedcost.xlsx) sheetname(Old);





